/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.SchemaGenerator;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import java.io.IOException;
import java.net.URL;

public class SchemaMapper {
    private static final JsonNodeFactory NODE_FACTORY = JsonNodeFactory.instance;
    private final RuleFactory ruleFactory;
    private final SchemaGenerator schemaGenerator;

    public SchemaMapper(RuleFactory ruleFactory, SchemaGenerator schemaGenerator) {
        this.ruleFactory = ruleFactory;
        this.schemaGenerator = schemaGenerator;
    }

    public SchemaMapper() {
        this(new RuleFactory(), new SchemaGenerator());
    }

    public void generate(JCodeModel codeModel, String className, String packageName, URL schemaUrl) throws IOException {
        JPackage jpackage = codeModel._package(packageName);
        ObjectNode schemaNode = this.readSchema(schemaUrl);
        this.ruleFactory.getSchemaRule().apply(className, (JsonNode)schemaNode, (JClassContainer)jpackage, new Schema(null, (JsonNode)schemaNode));
    }

    private ObjectNode readSchema(URL schemaUrl) {
        switch (this.ruleFactory.getGenerationConfig().getSourceType()) {
            case JSONSCHEMA: {
                ObjectNode schemaNode = NODE_FACTORY.objectNode();
                schemaNode.put("$ref", schemaUrl.toString());
                return schemaNode;
            }
            case JSON: {
                return this.schemaGenerator.schemaFromExample(schemaUrl);
            }
        }
        throw new IllegalArgumentException("Unrecognised source type: " + (Object)((Object)this.ruleFactory.getGenerationConfig().getSourceType()));
    }
}

