/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo;

import com.googlecode.jsonschema2pojo.AnnotationStyle;
import com.googlecode.jsonschema2pojo.Annotator;
import com.googlecode.jsonschema2pojo.GsonAnnotator;
import com.googlecode.jsonschema2pojo.Jackson1Annotator;
import com.googlecode.jsonschema2pojo.Jackson2Annotator;
import com.googlecode.jsonschema2pojo.NoopAnnotator;

public class AnnotatorFactory {
    public Annotator getAnnotator(AnnotationStyle style) {
        switch (style) {
            case JACKSON: 
            case JACKSON2: {
                return new Jackson2Annotator();
            }
            case JACKSON1: {
                return new Jackson1Annotator();
            }
            case GSON: {
                return new GsonAnnotator();
            }
            case NONE: {
                return new NoopAnnotator();
            }
        }
        throw new IllegalArgumentException("Unrecognised annotation style: " + (Object)((Object)style));
    }

    public Annotator getAnnotator(Class<? extends Annotator> clazz) {
        if (!Annotator.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The class name given as a custom annotator (" + clazz.getName() + ") does not refer to a class that implements " + Annotator.class.getName());
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Failed to create a custom annotator from the given class. An exception was thrown on trying to create a new instance.", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to create a custom annotator from the given class. It appears that we do not have access to this class - is both the class and its no-arg constructor marked public?", e);
        }
    }
}

