/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.GenerationConfig;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.googlecode.jsonschema2pojo.rules.SchemaRule;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;

public class TypeRule
implements SchemaRule<JClassContainer, JType> {
    private static final String DEFAULT_TYPE_NAME = "any";
    private final RuleFactory ruleFactory;

    protected TypeRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JClassContainer jClassContainer, Schema schema) {
        Object type;
        String propertyTypeName = this.getTypeName(node);
        if (propertyTypeName.equals("string")) {
            type = jClassContainer.owner().ref(String.class);
        } else if (propertyTypeName.equals("number")) {
            type = this.unboxIfNecessary((JType)jClassContainer.owner().ref(Double.class), this.ruleFactory.getGenerationConfig());
        } else if (propertyTypeName.equals("integer")) {
            JType typeToUseForIntegers = this.getIntegerType(jClassContainer.owner(), this.ruleFactory.getGenerationConfig());
            type = this.unboxIfNecessary(typeToUseForIntegers, this.ruleFactory.getGenerationConfig());
        } else {
            type = propertyTypeName.equals("boolean") ? this.unboxIfNecessary((JType)jClassContainer.owner().ref(Boolean.class), this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("object") ? this.ruleFactory.getObjectRule().apply(nodeName, node, jClassContainer.getPackage(), schema) : (propertyTypeName.equals("array") ? (JType)this.ruleFactory.getArrayRule().apply(nodeName, node, jClassContainer.getPackage(), schema) : jClassContainer.owner().ref(Object.class)));
        }
        if (node.has("format")) {
            type = this.ruleFactory.getFormatRule().apply(nodeName, node.get("format"), (JType)type, schema);
        }
        return type;
    }

    private String getTypeName(JsonNode node) {
        if (node.has("type") && node.get("type").isArray() && node.get("type").size() > 0) {
            return node.get("type").get(0).asText();
        }
        if (node.has("type")) {
            return node.get("type").asText();
        }
        return DEFAULT_TYPE_NAME;
    }

    private JType unboxIfNecessary(JType type, GenerationConfig config) {
        if (config.isUsePrimitives()) {
            return type.unboxify();
        }
        return type;
    }

    private JType getIntegerType(JCodeModel owner, GenerationConfig config) {
        if (config.isUseLongIntegers()) {
            return owner.ref(Long.class);
        }
        return owner.ref(Integer.class);
    }
}

