/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.googlecode.jsonschema2pojo.exception.GenerationException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;

public final class PrimitiveTypes {
    private PrimitiveTypes() {
    }

    public static boolean isPrimitive(String name, JCodeModel owner) {
        try {
            return JType.parse((JCodeModel)owner, (String)name) != owner.VOID;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static JPrimitiveType primitiveType(String name, JCodeModel owner) {
        try {
            return (JPrimitiveType)owner.parseType(name);
        }
        catch (ClassNotFoundException e) {
            throw new GenerationException("Given name does not refer to a primitive type, this type can't be found: " + name, e);
        }
    }
}

