/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.googlecode.jsonschema2pojo.GenerationConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class NameHelper {
    private static final String ILLEGAL_CHARACTER_REGEX = "[^0-9a-zA-Z_$]";
    private final GenerationConfig generationConfig;

    public NameHelper(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public String replaceIllegalCharacters(String name) {
        return name.replaceAll(ILLEGAL_CHARACTER_REGEX, "_");
    }

    public String normalizeName(String name) {
        if (Character.isDigit((name = this.capitalizeTrailingWords(name)).charAt(0))) {
            name = "_" + name;
        }
        return name;
    }

    public String capitalizeTrailingWords(String name) {
        char[] wordDelimiters = this.generationConfig.getPropertyWordDelimiters();
        if (StringUtils.containsAny((String)name, (char[])wordDelimiters)) {
            String capitalizedNodeName = WordUtils.capitalize((String)name, (char[])wordDelimiters);
            name = name.charAt(0) + capitalizedNodeName.substring(1);
            for (char c : wordDelimiters) {
                name = StringUtils.remove((String)name, (char)c);
            }
        }
        return name;
    }
}

