/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.googlecode.jsonschema2pojo.rules.SchemaRule;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JType;

public class JsonSchemaRule
implements SchemaRule<JClassContainer, JType> {
    private final RuleFactory ruleFactory;

    protected JsonSchemaRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JType apply(String nodeName, JsonNode schemaNode, JClassContainer generatableType, Schema schema) {
        if (schemaNode.has("$ref")) {
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText());
            schemaNode = schema.getContent();
            if (schema.isGenerated()) {
                return schema.getJavaType();
            }
            return this.apply(nodeName, schemaNode, generatableType, schema);
        }
        JType javaType = schemaNode.has("enum") ? (JType)this.ruleFactory.getEnumRule().apply(nodeName, schemaNode.get("enum"), generatableType, schema) : this.ruleFactory.getTypeRule().apply(nodeName, schemaNode, (JClassContainer)generatableType.getPackage(), schema);
        schema.setJavaTypeIfEmpty(javaType);
        return javaType;
    }
}

