/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.SchemaMapper;
import com.googlecode.jsonschema2pojo.exception.GenerationException;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.googlecode.jsonschema2pojo.rules.SchemaRule;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Generated;
import org.apache.commons.lang.StringUtils;

public class EnumRule
implements SchemaRule<JClassContainer, JDefinedClass> {
    private static final String VALUE_FIELD_NAME = "value";
    private final RuleFactory ruleFactory;

    protected EnumRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JClassContainer container, Schema schema) {
        JDefinedClass _enum = this.createEnum(nodeName, container);
        schema.setJavaTypeIfEmpty((JType)_enum);
        this.addGeneratedAnnotation(_enum);
        JFieldVar valueField = this.addValueField(_enum);
        this.addToString(_enum, valueField);
        this.addEnumConstants(node, _enum);
        this.addFactoryMethod(node, _enum);
        return _enum;
    }

    private JDefinedClass createEnum(String nodeName, JClassContainer container) {
        int modifiers = container.isPackage() ? 1 : 17;
        String name = this.getEnumName(nodeName);
        try {
            return container._class(modifiers, name, ClassType.ENUM);
        }
        catch (JClassAlreadyExistsException e) {
            throw new GenerationException(e);
        }
    }

    private void addFactoryMethod(JsonNode node, JDefinedClass _enum) {
        JMethod fromValue = _enum.method(17, (JType)_enum, "fromValue");
        JVar valueParam = fromValue.param(String.class, VALUE_FIELD_NAME);
        JBlock body = fromValue.body();
        JForEach forEach = body.forEach((JType)_enum, "c", (JExpression)_enum.staticInvoke("values"));
        JInvocation invokeEquals = forEach.var().ref(VALUE_FIELD_NAME).invoke("equals");
        invokeEquals.arg((JExpression)valueParam);
        forEach.body()._if((JExpression)invokeEquals)._then()._return((JExpression)forEach.var());
        JInvocation illegalArgumentException = JExpr._new((JClass)_enum.owner().ref(IllegalArgumentException.class));
        illegalArgumentException.arg((JExpression)valueParam);
        body._throw((JExpression)illegalArgumentException);
        this.ruleFactory.getAnnotator().enumCreatorMethod(fromValue);
    }

    private JFieldVar addValueField(JDefinedClass _enum) {
        JFieldVar valueField = _enum.field(12, String.class, VALUE_FIELD_NAME);
        JMethod constructor = _enum.constructor(4);
        JVar valueParam = constructor.param(String.class, VALUE_FIELD_NAME);
        JBlock body = constructor.body();
        body.assign((JAssignmentTarget)JExpr._this().ref((JVar)valueField), (JExpression)valueParam);
        return valueField;
    }

    private void addToString(JDefinedClass _enum, JFieldVar valueField) {
        JMethod toString = _enum.method(1, String.class, "toString");
        JBlock body = toString.body();
        body._return((JExpression)JExpr._this().ref((JVar)valueField));
        this.ruleFactory.getAnnotator().enumValueMethod(toString);
        toString.annotate(Override.class);
    }

    private void addEnumConstants(JsonNode node, JDefinedClass _enum) {
        Iterator values = node.elements();
        while (values.hasNext()) {
            JsonNode value = (JsonNode)values.next();
            if (value.isNull()) continue;
            JEnumConstant constant = _enum.enumConstant(this.getConstantName(value.asText()));
            constant.arg(JExpr.lit((String)value.asText()));
        }
    }

    private void addGeneratedAnnotation(JDefinedClass jclass) {
        JAnnotationUse generated = jclass.annotate(Generated.class);
        generated.param(VALUE_FIELD_NAME, SchemaMapper.class.getPackage().getName());
    }

    private String getEnumName(String nodeName) {
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(StringUtils.capitalize((String)nodeName));
        return this.ruleFactory.getNameHelper().normalizeName(className);
    }

    private String getConstantName(String nodeName) {
        ArrayList<String> enumNameGroups = new ArrayList<String>(Arrays.asList(StringUtils.splitByCharacterTypeCamelCase((String)nodeName)));
        String enumName = "";
        Iterator iter = enumNameGroups.iterator();
        while (iter.hasNext()) {
            if (!StringUtils.containsOnly((String)this.ruleFactory.getNameHelper().replaceIllegalCharacters((String)iter.next()), (String)"_")) continue;
            iter.remove();
        }
        enumName = StringUtils.upperCase((String)StringUtils.join(enumNameGroups, (String)"_"));
        if (StringUtils.isEmpty((String)enumName)) {
            enumName = "__EMPTY__";
        } else if (Character.isDigit(enumName.charAt(0))) {
            enumName = "_" + enumName;
        }
        return enumName;
    }
}

