/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.googlecode.jsonschema2pojo.rules.SchemaRule;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ArrayRule
implements SchemaRule<JPackage, JClass> {
    private final RuleFactory ruleFactory;

    protected ArrayRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JClass apply(String nodeName, JsonNode node, JPackage jpackage, Schema schema) {
        boolean uniqueItems = node.has("uniqueItems") && node.get("uniqueItems").asBoolean();
        boolean rootSchemaIsArray = !schema.isGenerated();
        Object itemType = node.has("items") ? this.ruleFactory.getSchemaRule().apply(this.makeSingular(nodeName), node.get("items"), (JClassContainer)jpackage, schema) : jpackage.owner().ref(Object.class);
        JClass arrayType = uniqueItems ? jpackage.owner().ref(Set.class).narrow((JType)itemType) : jpackage.owner().ref(List.class).narrow((JType)itemType);
        if (rootSchemaIsArray) {
            schema.setJavaType((JType)arrayType);
        }
        return arrayType;
    }

    private String makeSingular(String nodeName) {
        if (StringUtils.endsWith((String)nodeName, (String)"ies")) {
            return StringUtils.removeEnd((String)nodeName, (String)"ies") + "y";
        }
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)nodeName, (String)"s"), (String)"S");
    }
}

