/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonschema2pojo.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonschema2pojo.Schema;
import com.googlecode.jsonschema2pojo.rules.RuleFactory;
import com.googlecode.jsonschema2pojo.rules.SchemaRule;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;

public class AdditionalPropertiesRule
implements SchemaRule<JDefinedClass, JDefinedClass> {
    private final RuleFactory ruleFactory;

    protected AdditionalPropertiesRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    @Override
    public JDefinedClass apply(String nodeName, JsonNode node, JDefinedClass jclass, Schema schema) {
        if (node != null && node.isBoolean() && !node.asBoolean()) {
            return jclass;
        }
        Object propertyType = node != null && node.size() != 0 ? this.ruleFactory.getSchemaRule().apply(nodeName + "Property", node, (JClassContainer)jclass, schema) : jclass.owner().ref(Object.class);
        JFieldVar field = this.addAdditionalPropertiesField(jclass, (JType)propertyType);
        this.addGetter(jclass, field);
        this.addSetter(jclass, (JType)propertyType, field);
        return jclass;
    }

    private JFieldVar addAdditionalPropertiesField(JDefinedClass jclass, JType propertyType) {
        JClass propertiesMapType = jclass.owner().ref(Map.class);
        propertiesMapType = propertiesMapType.narrow(new JClass[]{jclass.owner().ref(String.class), propertyType.boxify()});
        JClass propertiesMapImplType = jclass.owner().ref(HashMap.class);
        propertiesMapImplType = propertiesMapImplType.narrow(new JClass[]{jclass.owner().ref(String.class), propertyType.boxify()});
        JFieldVar field = jclass.field(4, (JType)propertiesMapType, "additionalProperties");
        field.init((JExpression)JExpr._new((JClass)propertiesMapImplType));
        return field;
    }

    private void addSetter(JDefinedClass jclass, JType propertyType, JFieldVar field) {
        JMethod setter = jclass.method(1, Void.TYPE, "setAdditionalProperties");
        this.ruleFactory.getAnnotator().anySetter(setter);
        JVar nameParam = setter.param(String.class, "name");
        JVar valueParam = setter.param(propertyType, "value");
        JInvocation mapInvocation = setter.body().invoke((JExpression)JExpr._this().ref((JVar)field), "put");
        mapInvocation.arg((JExpression)nameParam);
        mapInvocation.arg((JExpression)valueParam);
    }

    private JMethod addGetter(JDefinedClass jclass, JFieldVar field) {
        JMethod getter = jclass.method(1, field.type(), "getAdditionalProperties");
        this.ruleFactory.getAnnotator().anyGetter(getter);
        getter.body()._return((JExpression)JExpr._this().ref((JVar)field));
        return getter;
    }
}

