/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.maven;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.maven.ReportWriter;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class ReportWriterImpl
implements ReportWriter {
    private final File reportFile;
    private final JSLintResultFormatter formatter;
    private BufferedWriter writer;

    public ReportWriterImpl(File reportFile, JSLintResultFormatter formatter) {
        this.reportFile = reportFile;
        this.formatter = formatter;
    }

    @Override
    public void close() {
        try {
            if (this.formatter.footer() != null && this.writer != null) {
                this.writer.write(this.formatter.footer());
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)this.writer);
        }
    }

    public File getReportFile() {
        return this.reportFile;
    }

    @Override
    public void open() {
        try {
            Files.createParentDirs((File)this.reportFile);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), Charset.forName("UTF-8")));
            if (this.formatter.header() != null) {
                this.writer.write(this.formatter.header());
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void report(JSLintResult result) {
        try {
            this.writer.write(this.formatter.format(result));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

