/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.StandardMBean;
import mockit.coverage.CodeCoverage;
import mockit.coverage.standalone.CoverageControlMBean;
import mockit.coverage.standalone.Description;

public final class CoverageControl
extends StandardMBean
implements CoverageControlMBean,
PersistentMBean {
    static void create() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            CoverageControl mxBean = new CoverageControl();
            mbeanServer.registerMBean(mxBean, new ObjectName("JMockit Coverage:type=CoverageControl"));
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public CoverageControl() throws NotCompliantMBeanException, MBeanException {
        super(CoverageControlMBean.class);
        this.load();
    }

    protected String getDescription(MBeanInfo info) {
        return CoverageControlMBean.class.getAnnotation(Description.class).value();
    }

    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return "resetState";
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription("get" + info.getName());
    }

    private String getDescription(String methodName) {
        return this.getMethod(methodName).getAnnotation(Description.class).value();
    }

    private Method getMethod(String methodName) {
        for (Method method : CoverageControlMBean.class.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription(info.getName());
    }

    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        Method method = this.getMethod(op.getName());
        Description desc = (Description)method.getParameterAnnotations()[sequence][0];
        return desc.value();
    }

    protected int getImpact(MBeanOperationInfo info) {
        return 1;
    }

    public String getOutput() {
        return this.getProperty("output", "html").replace("-nocp", "");
    }

    public void setOutput(String output) {
        this.modifyConfigurationProperty("output", "html".equals(output) ? "html-nocp" : output);
    }

    public String getWorkingDir() {
        return new File(".").getAbsoluteFile().getParent();
    }

    public String getOutputDir() {
        return this.getProperty("outputDir");
    }

    public void setOutputDir(String outputDir) {
        this.modifyConfigurationProperty("outputDir", outputDir);
    }

    public String getSrcDirs() {
        return this.getProperty("srcDirs");
    }

    public void setSrcDirs(String srcDirs) {
        this.modifyConfigurationProperty("srcDirs", srcDirs);
    }

    public String getClasses() {
        return this.getProperty("classes");
    }

    public void setClasses(String classes) {
        this.modifyConfigurationProperty("classes", classes);
    }

    public String getExcludes() {
        return this.getProperty("excludes");
    }

    public void setExcludes(String excludes) {
        this.modifyConfigurationProperty("excludes", excludes);
    }

    public String getMetrics() {
        return this.getProperty("metrics", "all");
    }

    public void setMetrics(String metrics) {
        this.modifyConfigurationProperty("metrics", metrics);
    }

    private String getProperty(String property) {
        return System.getProperty(this.propertyName(property), "");
    }

    private String getProperty(String property, String defaultValue) {
        return System.getProperty(this.propertyName(property), defaultValue);
    }

    private String propertyName(String name) {
        return "jmockit-coverage-" + Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private void modifyConfigurationProperty(String name, String value) {
        this.setConfigurationProperty(name, value);
        CodeCoverage.resetConfiguration();
        this.store();
    }

    private void setConfigurationProperty(String name, String value) {
        System.setProperty(this.propertyName(name), value);
    }

    public void generateOutput(boolean resetState) {
        CodeCoverage.generateOutput(resetState);
    }

    public void load() throws MBeanException {
        Preferences preferences = Preferences.userNodeForPackage(CoverageControl.class);
        try {
            for (String property : preferences.keys()) {
                String commandLineValue = this.getProperty(property);
                if (commandLineValue.length() != 0) continue;
                String value = preferences.get(property, "");
                this.setConfigurationProperty(property, value);
            }
        }
        catch (BackingStoreException e) {
            throw new MBeanException(e);
        }
    }

    public void store() {
        Preferences preferences = Preferences.userNodeForPackage(CoverageControl.class);
        for (MBeanAttributeInfo info : this.getMBeanInfo().getAttributes()) {
            String property = info.getName();
            String value = this.getProperty(property);
            preferences.put(property, value);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

