/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.parsing;

import mockit.coverage.reporting.parsing.LineElement;

public final class LineParser {
    private static final String SEPARATORS = ".,;()";
    private int lineNum;
    private String line;
    private LineElement initialElement;
    private boolean inComments;
    private LineElement currentElement;
    private int lineLength;
    private int startPos;
    private boolean inCodeElement;
    private int pos;
    private int currChar;

    public int getNumber() {
        return this.lineNum;
    }

    public boolean isInComments() {
        return this.inComments;
    }

    public boolean isBlankLine() {
        int n = this.line.length();
        for (int i = 0; i < n; ++i) {
            char c = this.line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public LineElement getInitialElement() {
        return this.initialElement;
    }

    boolean parse(String line) {
        ++this.lineNum;
        this.initialElement = null;
        this.currentElement = null;
        this.line = line;
        this.lineLength = line.length();
        this.startPos = this.inComments ? 0 : -1;
        this.inCodeElement = false;
        this.pos = 0;
        while (this.pos < this.lineLength) {
            this.currChar = line.codePointAt(this.pos);
            if (this.parseComment()) break;
            this.parseSeparatorsAndCode();
            ++this.pos;
        }
        if (this.startPos >= 0) {
            this.addFinalElement();
        } else if (this.initialElement == null) {
            this.initialElement = new LineElement(LineElement.ElementType.SEPARATOR, "");
            return false;
        }
        return !this.inComments && !this.isBlankLine();
    }

    private void parseSeparatorsAndCode() {
        boolean separator = this.isSeparator();
        if (!this.inCodeElement && separator) {
            this.startNewElementIfNotYetStarted();
        } else if (!this.inCodeElement && !separator) {
            if (this.startPos >= 0) {
                this.addElement();
            }
            this.inCodeElement = true;
            this.startPos = this.pos;
        } else if (separator) {
            this.addElement();
            this.inCodeElement = false;
            this.startPos = this.pos;
        }
    }

    private boolean isSeparator() {
        return Character.isWhitespace(this.currChar) || SEPARATORS.indexOf(this.currChar) >= 0;
    }

    private void startNewElementIfNotYetStarted() {
        if (this.startPos < 0) {
            this.startPos = this.pos;
        }
    }

    private boolean parseComment() {
        if (this.inComments && this.parseUntilEndOfLineOrEndOfComment()) {
            return true;
        }
        while (this.currChar == 47 && this.pos < this.lineLength - 1) {
            int c2 = this.line.codePointAt(this.pos + 1);
            if (c2 == 47) {
                this.endCodeElementIfPending();
                this.startNewElementIfNotYetStarted();
                this.inComments = true;
                this.addFinalElement();
                this.inComments = false;
                this.startPos = -1;
                return true;
            }
            if (c2 != 42) break;
            this.endCodeElementIfPending();
            this.startNewElementIfNotYetStarted();
            this.inComments = true;
            this.pos += 2;
            if (!this.parseUntilEndOfLineOrEndOfComment()) continue;
            return true;
        }
        return false;
    }

    private void endCodeElementIfPending() {
        if (this.inCodeElement) {
            this.addElement();
            this.startPos = this.pos;
            this.inCodeElement = false;
        }
    }

    private boolean parseUntilEndOfLineOrEndOfComment() {
        while (this.pos < this.lineLength) {
            this.currChar = this.line.codePointAt(this.pos);
            if (this.currChar == 42 && this.pos < this.lineLength - 1 && this.line.codePointAt(this.pos + 1) == 47) {
                this.pos += 2;
                this.addElement();
                this.startPos = -1;
                this.inComments = false;
                break;
            }
            ++this.pos;
        }
        if (this.pos < this.lineLength) {
            this.currChar = this.line.codePointAt(this.pos);
            return false;
        }
        return true;
    }

    private void addFinalElement() {
        String text = this.line.substring(this.startPos);
        this.addElement(text);
    }

    private void addElement() {
        String text = this.pos > 0 ? this.line.substring(this.startPos, this.pos) : this.line.substring(this.startPos);
        this.addElement(text);
    }

    private void addElement(String text) {
        LineElement.ElementType type = this.inComments ? LineElement.ElementType.COMMENT : (this.inCodeElement ? LineElement.ElementType.CODE : LineElement.ElementType.SEPARATOR);
        LineElement newElement = new LineElement(type, text);
        if (this.initialElement == null) {
            this.initialElement = newElement;
        } else {
            this.currentElement.setNext(newElement);
        }
        this.currentElement = newElement;
    }
}

