/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.dataCoverage;

import mockit.coverage.dataItems.FieldData;
import mockit.coverage.dataItems.InstanceFieldData;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.dataItems.StaticFieldData;
import mockit.coverage.reporting.parsing.FileParser;
import mockit.coverage.reporting.parsing.LineElement;

public final class DataCoverageOutput {
    private final StringBuilder openingTag = new StringBuilder(50);
    private final PerFileDataCoverage coverageInfo;
    private int nextField;
    private String classAndFieldNames;
    private String className;
    private String fieldName;

    public DataCoverageOutput(PerFileDataCoverage coverageInfo) {
        this.coverageInfo = coverageInfo;
        this.moveToNextField();
    }

    private void moveToNextField() {
        if (this.nextField >= this.coverageInfo.allFields.size()) {
            this.classAndFieldNames = null;
            this.className = null;
            this.fieldName = null;
            return;
        }
        this.classAndFieldNames = this.coverageInfo.allFields.get(this.nextField);
        ++this.nextField;
        int p = this.classAndFieldNames.indexOf(46);
        this.className = this.classAndFieldNames.substring(0, p);
        this.fieldName = this.classAndFieldNames.substring(p + 1);
    }

    public void writeCoverageInfoIfLineStartsANewFieldDeclaration(FileParser fileParser) {
        LineElement initialLineElement;
        LineElement elementWithFieldName;
        if (this.classAndFieldNames != null && this.className.equals(fileParser.getCurrentlyPendingClass()) && (elementWithFieldName = (initialLineElement = fileParser.lineParser.getInitialElement()).findWord(this.fieldName)) != null) {
            this.buildOpeningTagForFieldWrapper();
            elementWithFieldName.wrapText(this.openingTag.toString(), "</span>");
            this.moveToNextField();
        }
    }

    private void buildOpeningTagForFieldWrapper() {
        this.openingTag.setLength(0);
        this.openingTag.append("<span class='");
        StaticFieldData staticData = this.coverageInfo.getStaticFieldData(this.classAndFieldNames);
        boolean staticField = staticData != null;
        this.openingTag.append(staticField ? "static" : "instance");
        this.openingTag.append(this.coverageInfo.isCovered(this.classAndFieldNames) ? " covered" : " uncovered");
        InstanceFieldData instanceData = this.coverageInfo.getInstanceFieldData(this.classAndFieldNames);
        if (staticField || instanceData != null) {
            this.openingTag.append("' title='");
            this.appendAccessCounts(staticField ? staticData : instanceData);
        }
        this.openingTag.append("'>");
    }

    private void appendAccessCounts(FieldData fieldData) {
        this.openingTag.append("Reads: ").append(fieldData.getReadCount());
        this.openingTag.append(" Writes: ").append(fieldData.getWriteCount());
    }
}

