/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mockit.coverage.paths.Node;
import mockit.coverage.paths.NodeBuilder;
import mockit.coverage.paths.Path;
import mockit.coverage.paths.PathBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodCoverageData
implements Serializable {
    private static final long serialVersionUID = -5073393714435522417L;
    public final String methodName;
    private List<Node> nodes;
    private int firstLine;
    private int lastLine;
    private transient ThreadLocal<List<Node>> nodesReached;
    private transient ThreadLocal<Integer> previousNodeIndex;
    public List<Path> paths;
    private List<Path> nonShadowedPaths;

    public MethodCoverageData(String methodName) {
        this.methodName = methodName;
    }

    public void buildPaths(int lastLine, NodeBuilder nodeBuilder) {
        this.firstLine = nodeBuilder.firstLine;
        this.lastLine = lastLine;
        this.nodes = nodeBuilder.nodes;
        this.paths = new PathBuilder().buildPaths(this.nodes);
        this.buildListOfNonShadowedPaths();
        this.nodesReached = new ThreadLocal();
        this.previousNodeIndex = new ThreadLocal();
    }

    private void buildListOfNonShadowedPaths() {
        this.nonShadowedPaths = new ArrayList<Path>(this.paths.size());
        for (Path path : this.paths) {
            if (path.isShadowed()) continue;
            this.nonShadowedPaths.add(path);
        }
    }

    public int getFirstLineInBody() {
        return this.firstLine;
    }

    public int getLastLineInBody() {
        return this.lastLine;
    }

    public void markNodeAsReached(int nodeIndex) {
        if (nodeIndex == 0) {
            this.clearNodes();
        }
        Node node = this.nodes.get(nodeIndex);
        List<Node> currentNodesReached = this.nodesReached.get();
        if (!(node.wasReached() || nodeIndex != 0 && nodeIndex <= this.previousNodeIndex.get())) {
            node.setReached(Boolean.TRUE);
            currentNodesReached.add(node);
            this.previousNodeIndex.set(nodeIndex);
        }
        if (node instanceof Node.Exit) {
            Node.Exit exitNode = (Node.Exit)node;
            for (Path path : exitNode.paths) {
                if (!path.countExecutionIfAllNodesWereReached(currentNodesReached)) continue;
                return;
            }
        }
    }

    private void clearNodes() {
        for (Node node : this.nodes) {
            node.setReached(null);
        }
        this.nodesReached.set(new ArrayList());
        this.previousNodeIndex.set(0);
    }

    public List<Path> getPaths() {
        return this.nonShadowedPaths;
    }

    public int getExecutionCount() {
        int totalCount = 0;
        for (Path path : this.nonShadowedPaths) {
            totalCount += path.getExecutionCount();
        }
        return totalCount;
    }

    public int getTotalPaths() {
        return this.nonShadowedPaths.size();
    }

    public int getCoveredPaths() {
        int coveredCount = 0;
        for (Path path : this.nonShadowedPaths) {
            if (path.getExecutionCount() <= 0) continue;
            ++coveredCount;
        }
        return coveredCount;
    }

    public void addCountsFromPreviousTestRun(MethodCoverageData previousData) {
        for (int i = 0; i < this.paths.size(); ++i) {
            Path path = this.paths.get(i);
            Path previousPath = previousData.paths.get(i);
            path.addCountFromPreviousTestRun(previousPath);
        }
    }

    public void reset() {
        this.clearNodes();
        for (Path path : this.paths) {
            path.reset();
        }
    }
}

