/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import mockit.coverage.CallPoint;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.lines.LineCoverageData;

public final class PerFileLineCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = 6318915843739466316L;
    public final SortedMap<Integer, LineCoverageData> lineToLineData = new TreeMap<Integer, LineCoverageData>();
    private transient int totalSegments;
    private transient int coveredSegments;

    public PerFileLineCoverage() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.coveredSegments = -1;
        this.totalSegments = -1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initializeCache();
        in.defaultReadObject();
    }

    public LineCoverageData addLine(int line) {
        LineCoverageData lineData = (LineCoverageData)this.lineToLineData.get(line);
        if (lineData == null) {
            lineData = new LineCoverageData();
            this.lineToLineData.put(line, lineData);
        }
        return lineData;
    }

    public void registerExecution(int line, CallPoint callPoint) {
        LineCoverageData lineData = (LineCoverageData)this.lineToLineData.get(line);
        lineData.registerExecution(callPoint);
    }

    public void registerExecution(int line, int segment, boolean jumped, CallPoint callPoint) {
        LineCoverageData lineData = (LineCoverageData)this.lineToLineData.get(line);
        lineData.registerExecution(segment, jumped, callPoint);
    }

    public int getTotalItems() {
        this.computeValuesIfNeeded();
        return this.totalSegments;
    }

    public int getCoveredItems() {
        this.computeValuesIfNeeded();
        return this.coveredSegments;
    }

    public int getCoveragePercentage() {
        this.computeValuesIfNeeded();
        return CoveragePercentage.calculate(this.coveredSegments, this.totalSegments);
    }

    private void computeValuesIfNeeded() {
        if (this.totalSegments >= 0) {
            return;
        }
        this.coveredSegments = 0;
        this.totalSegments = 0;
        for (LineCoverageData line : this.lineToLineData.values()) {
            this.totalSegments += line.getNumberOfSegments();
            this.coveredSegments += line.getNumberOfCoveredSegments();
        }
    }

    public void reset() {
        for (LineCoverageData lineData : this.lineToLineData.values()) {
            lineData.reset();
        }
        this.initializeCache();
    }

    public void mergeInformation(PerFileLineCoverage previousCoverage) {
        Integer line;
        SortedMap<Integer, LineCoverageData> previousInfo = previousCoverage.lineToLineData;
        for (Map.Entry<Integer, LineCoverageData> entry : this.lineToLineData.entrySet()) {
            line = entry.getKey();
            LineCoverageData previousLineInfo = (LineCoverageData)previousInfo.get(line);
            if (previousLineInfo == null) continue;
            LineCoverageData lineInfo = entry.getValue();
            lineInfo.addCountsFromPreviousTestRun(previousLineInfo);
        }
        for (Map.Entry<Integer, LineCoverageData> entry : previousInfo.entrySet()) {
            line = entry.getKey();
            if (this.lineToLineData.containsKey(line)) continue;
            this.lineToLineData.put(line, entry.getValue());
        }
    }
}

