/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.data.PerFileCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageData
implements Serializable {
    private static final long serialVersionUID = -4860004226098360259L;
    private static final CoverageData instance = new CoverageData();
    private boolean withCallPoints;
    private final Map<String, FileCoverageData> fileToFileData = new ConcurrentHashMap<String, FileCoverageData>();

    public static CoverageData instance() {
        return instance;
    }

    public boolean isWithCallPoints() {
        return this.withCallPoints;
    }

    public void setWithCallPoints(boolean withCallPoints) {
        this.withCallPoints = withCallPoints;
    }

    public Map<String, FileCoverageData> getFileToFileDataMap() {
        return Collections.unmodifiableMap(this.fileToFileData);
    }

    public FileCoverageData addFile(String file, String kindOfTopLevelType) {
        FileCoverageData fileData = this.getFileData(file);
        if (fileData == null) {
            fileData = new FileCoverageData(kindOfTopLevelType);
            this.fileToFileData.put(file, fileData);
        } else if (kindOfTopLevelType != null) {
            fileData.kindOfTopLevelType = kindOfTopLevelType;
        }
        return fileData;
    }

    public FileCoverageData getFileData(String file) {
        return this.fileToFileData.get(file);
    }

    public boolean isEmpty() {
        return this.fileToFileData.isEmpty();
    }

    public void clear() {
        this.fileToFileData.clear();
    }

    public int getPercentage(Metrics metric, String fileNamePrefix) {
        int coveredItems = 0;
        int totalItems = 0;
        for (Map.Entry<String, FileCoverageData> fileAndFileData : this.fileToFileData.entrySet()) {
            String sourceFile = fileAndFileData.getKey();
            if (fileNamePrefix != null && !sourceFile.startsWith(fileNamePrefix)) continue;
            FileCoverageData fileData = fileAndFileData.getValue();
            PerFileCoverage coverageInfo = fileData.getPerFileCoverage(metric);
            coveredItems += coverageInfo.getCoveredItems();
            totalItems += coverageInfo.getTotalItems();
        }
        return CoveragePercentage.calculate(coveredItems, totalItems);
    }

    public int getSmallestPerFilePercentage(Metrics metric) {
        int minPercentage = Integer.MAX_VALUE;
        for (FileCoverageData fileData : this.fileToFileData.values()) {
            PerFileCoverage coverageInfo = fileData.getPerFileCoverage(metric);
            int percentage = coverageInfo.getCoveragePercentage();
            if (percentage < 0 || percentage >= minPercentage) continue;
            minPercentage = percentage;
        }
        return minPercentage;
    }

    public void reset() {
        for (FileCoverageData fileCoverageData : this.fileToFileData.values()) {
            fileCoverageData.reset();
        }
    }

    public void fillLastModifiedTimesForAllClassFiles() {
        Iterator<Map.Entry<String, FileCoverageData>> itr = this.fileToFileData.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, FileCoverageData> fileAndFileData = itr.next();
            File coveredClassFile = this.getClassFile(fileAndFileData.getKey());
            if (coveredClassFile != null) {
                fileAndFileData.getValue().lastModified = coveredClassFile.lastModified();
                continue;
            }
            itr.remove();
        }
    }

    private File getClassFile(String sourceFilePath) {
        String sourceFilePathNoExt = sourceFilePath.substring(0, sourceFilePath.lastIndexOf(46));
        String className = sourceFilePathNoExt.replace('/', '.');
        Class<?> coveredClass = this.findCoveredClass(className);
        if (coveredClass == null) {
            return null;
        }
        CodeSource codeSource = coveredClass.getProtectionDomain().getCodeSource();
        String pathToClassFile = codeSource.getLocation().getPath() + sourceFilePathNoExt + ".class";
        return new File(pathToClassFile);
    }

    private Class<?> findCoveredClass(String className) {
        ClassLoader currentCL = this.getClass().getClassLoader();
        Class<?> coveredClass = this.loadClass(className, currentCL);
        if (coveredClass == null) {
            ClassLoader contextCL;
            ClassLoader systemCL = ClassLoader.getSystemClassLoader();
            if (systemCL != currentCL) {
                coveredClass = this.loadClass(className, systemCL);
            }
            if (coveredClass == null && (contextCL = Thread.currentThread().getContextClassLoader()) != null && contextCL != systemCL) {
                coveredClass = this.loadClass(className, contextCL);
            }
        }
        return coveredClass;
    }

    private Class<?> loadClass(String className, ClassLoader loader) {
        try {
            return Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
        catch (NoClassDefFoundError ignored) {
            return null;
        }
    }

    public static CoverageData readDataFromFile(File dataFile) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
        try {
            CoverageData coverageData = (CoverageData)input.readObject();
            return coverageData;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Serialized class in coverage data file \"" + dataFile + "\" not found in classpath", e);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataToFile(File dataFile) throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile)));
        try {
            output.writeObject(this);
        }
        finally {
            output.close();
        }
    }

    public void merge(CoverageData previousData) {
        this.withCallPoints |= previousData.withCallPoints;
        for (Map.Entry<String, FileCoverageData> previousFileAndFileData : previousData.fileToFileData.entrySet()) {
            String previousFile = previousFileAndFileData.getKey();
            FileCoverageData previousFileData = previousFileAndFileData.getValue();
            FileCoverageData fileData = this.fileToFileData.get(previousFile);
            if (fileData == null) {
                this.fileToFileData.put(previousFile, previousFileData);
                continue;
            }
            if (previousFileData.lastModified != fileData.lastModified) continue;
            fileData.mergeWithDataFromPreviousTestRun(previousFileData);
        }
    }
}

