/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import mockit.coverage.AccretionFile;
import mockit.coverage.DataFileMerging;
import mockit.coverage.data.CoverageData;
import mockit.coverage.modification.ClassModification;
import mockit.coverage.modification.ClassesNotLoaded;
import mockit.coverage.reporting.BasicCoverageReport;
import mockit.coverage.reporting.FullCoverageReport;
import mockit.coverage.standalone.Startup;

final class OutputFileGenerator {
    private static final String COVERAGE_PREFIX = "jmockit-coverage-";
    private static final String[] ALL_SOURCE_DIRS = new String[0];
    private final ClassModification classModification;
    private final String[] outputFormats;
    private final String outputDir;
    private final String[] sourceDirs;

    OutputFileGenerator(ClassModification classModification) {
        this.classModification = classModification;
        this.outputFormats = this.getOutputFormat();
        this.outputDir = this.getCoverageProperty("outputDir");
        String commaSeparatedDirs = System.getProperty("jmockit-coverage-srcDirs");
        this.sourceDirs = commaSeparatedDirs == null ? (Startup.isTestRun() ? ALL_SOURCE_DIRS : null) : (commaSeparatedDirs.length() == 0 ? null : commaSeparatedDirs.split(","));
    }

    private String[] getOutputFormat() {
        String[] stringArray;
        String format = this.getCoverageProperty("output");
        if (format.length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "html-nocp";
        } else {
            stringArray = format.trim().split("\\s*,\\s*|\\s+");
        }
        return stringArray;
    }

    private String getCoverageProperty(String suffix) {
        return System.getProperty(COVERAGE_PREFIX + suffix, "");
    }

    boolean isOutputToBeGenerated() {
        return this.isOutputWithCallpointsToBeGenerated() || this.hasOutputFormat("html-nocp");
    }

    private boolean isOutputWithCallpointsToBeGenerated() {
        return this.hasOutputFormat("html") || this.hasOutputFormat("serial") || this.hasOutputFormat("merge");
    }

    boolean isWithCallPoints() {
        return Startup.isTestRun() && this.isOutputWithCallpointsToBeGenerated() && !this.hasOutputFormat("html-nocp");
    }

    private boolean hasOutputFormat(String format) {
        for (String outputFormat : this.outputFormats) {
            if (!format.equals(outputFormat)) continue;
            return true;
        }
        return false;
    }

    void generate() {
        CoverageData coverageData = CoverageData.instance();
        if (coverageData.isEmpty()) {
            System.out.println("JMockit: No classes were instrumented for coverage; please make sure that classes selected for coverage have been compiled with debug information.");
            return;
        }
        if (this.classModification != null) {
            new ClassesNotLoaded(this.classModification).gatherCoverageData();
        }
        this.createOutputDirIfSpecifiedButNotExists();
        try {
            this.generateAccretionDataFileIfRequested(coverageData);
            this.generateHTMLReportIfRequested(coverageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void generateAggregateReportFromInputFiles(String[] inputPaths) {
        this.createOutputDirIfSpecifiedButNotExists();
        try {
            CoverageData coverageData = new DataFileMerging(inputPaths).merge();
            this.generateHTMLReportIfRequested(coverageData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createOutputDirIfSpecifiedButNotExists() {
        File outDir;
        if (this.outputDir.length() > 0 && !(outDir = new File(this.outputDir)).exists()) {
            boolean dirCreated = outDir.mkdir();
            assert (dirCreated) : "Failed to create specified output dir: " + this.outputDir;
        }
    }

    private void generateAccretionDataFileIfRequested(CoverageData newData) throws IOException {
        if (this.hasOutputFormat("serial")) {
            new AccretionFile(this.outputDir, newData).generate();
        } else if (this.hasOutputFormat("merge")) {
            AccretionFile accretionFile = new AccretionFile(this.outputDir, newData);
            accretionFile.mergeDataFromExistingFileIfAny();
            accretionFile.generate();
        }
    }

    private void generateHTMLReportIfRequested(CoverageData coverageData) throws IOException {
        if (this.hasOutputFormat("html-nocp")) {
            new BasicCoverageReport(this.outputDir, this.sourceDirs, coverageData).generate();
        } else if (this.hasOutputFormat("html")) {
            new FullCoverageReport(this.outputDir, this.sourceDirs, coverageData).generate();
        }
    }
}

