/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mockit.coverage.Metrics;
import mockit.coverage.data.CoverageData;

final class CoverageCheck {
    private final List<Threshold> thresholds;
    private boolean allThresholdsSatisfied;

    CoverageCheck() {
        String configuration = System.getProperty("jmockit-coverage-check", "");
        if (configuration.length() == 0) {
            this.thresholds = null;
            return;
        }
        String[] configurationParameters = configuration.split(";");
        int n = configurationParameters.length;
        this.thresholds = new ArrayList<Threshold>(n);
        for (String configurationParameter : configurationParameters) {
            this.thresholds.add(new Threshold(configurationParameter));
        }
    }

    void verifyThresholds() {
        if (this.thresholds == null) {
            return;
        }
        this.allThresholdsSatisfied = true;
        for (final Threshold threshold : this.thresholds) {
            Metrics.performAction(new Metrics.Action(){

                public void perform(Metrics metric) {
                    CoverageCheck.this.allThresholdsSatisfied = (byte)(CoverageCheck.this.allThresholdsSatisfied & (threshold.verifyMinimum(metric) ? 1 : 0));
                }
            });
        }
        this.createOrDeleteIndicatorFile();
        if (!this.allThresholdsSatisfied) {
            throw new AssertionError((Object)"JMockit: minimum coverage percentages not reached; see previous messages.");
        }
    }

    private void createOrDeleteIndicatorFile() {
        File indicatorFile = new File("coverage.check.failed");
        if (indicatorFile.exists()) {
            if (this.allThresholdsSatisfied) {
                indicatorFile.delete();
            } else {
                indicatorFile.setLastModified(System.currentTimeMillis());
            }
        } else if (!this.allThresholdsSatisfied) {
            try {
                indicatorFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class Threshold {
        private final String sourceFilePrefix;
        private final String scopeDescription;
        private final int[] minPercentages;

        Threshold(String configurationParameter) {
            String csvPercentages;
            String[] sourceFilePrefixAndMinPercentages = configurationParameter.split(":");
            if (sourceFilePrefixAndMinPercentages.length == 1) {
                this.sourceFilePrefix = null;
                this.scopeDescription = "";
                csvPercentages = sourceFilePrefixAndMinPercentages[0];
            } else {
                String scope = sourceFilePrefixAndMinPercentages[0].trim();
                if ("perFile".equals(scope)) {
                    this.sourceFilePrefix = scope;
                    this.scopeDescription = " for some source files";
                } else {
                    this.sourceFilePrefix = scope.replace('.', '/');
                    this.scopeDescription = " for " + scope;
                }
                csvPercentages = sourceFilePrefixAndMinPercentages[1];
            }
            this.minPercentages = new int[Metrics.values().length];
            this.parseMinimumPercentages(csvPercentages);
        }

        private void parseMinimumPercentages(String csvPercentages) {
            String[] textualPercentages = csvPercentages.split(",");
            int n = Math.min(textualPercentages.length, this.minPercentages.length);
            for (int i = 0; i < n; ++i) {
                String textualValue = textualPercentages[i].trim();
                try {
                    this.minPercentages[i] = Integer.parseInt(textualValue);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }

        boolean verifyMinimum(Metrics metric) {
            CoverageData coverageData = CoverageData.instance();
            int percentage = "perFile".equals(this.sourceFilePrefix) ? coverageData.getSmallestPerFilePercentage(metric) : coverageData.getPercentage(metric, this.sourceFilePrefix);
            return percentage < 0 || this.verifyMinimum(metric, percentage);
        }

        private boolean verifyMinimum(Metrics metric, int percentage) {
            int minPercentage = this.minPercentages[metric.ordinal()];
            if (percentage < minPercentage) {
                System.out.println("JMockit: " + (Object)((Object)metric) + " coverage too low" + this.scopeDescription + ": " + percentage + "% < " + minPercentage + '%');
                return false;
            }
            return true;
        }
    }
}

