/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

public final class DVBAlphaComposite {
    public static final int CLEAR = 1;
    public static final int SRC = 2;
    public static final int SRC_OVER = 3;
    public static final int DST_OVER = 4;
    public static final int SRC_IN = 5;
    public static final int DST_IN = 6;
    public static final int SRC_OUT = 7;
    public static final int DST_OUT = 8;
    public static final DVBAlphaComposite Clear = new DVBAlphaComposite(1);
    public static final DVBAlphaComposite Src = new DVBAlphaComposite(2);
    public static final DVBAlphaComposite SrcOver = new DVBAlphaComposite(3);
    public static final DVBAlphaComposite DstOver = new DVBAlphaComposite(4);
    public static final DVBAlphaComposite SrcIn = new DVBAlphaComposite(5);
    public static final DVBAlphaComposite DstIn = new DVBAlphaComposite(6);
    public static final DVBAlphaComposite SrcOut = new DVBAlphaComposite(7);
    public static final DVBAlphaComposite DstOut = new DVBAlphaComposite(8);
    private static final int MIN_RULE = 1;
    private static final int MAX_RULE = 8;
    float extraAlpha;
    int rule;

    private DVBAlphaComposite(int rule) {
        this(rule, 1.0f);
    }

    private DVBAlphaComposite(int rule, float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha value out of range");
        }
        if (rule < 1 || rule > 8) {
            throw new IllegalArgumentException("unknown composite rule");
        }
        this.rule = rule;
        this.extraAlpha = alpha;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DVBAlphaComposite)) {
            return false;
        }
        DVBAlphaComposite ac = (DVBAlphaComposite)obj;
        if (this.rule != ac.rule) {
            return false;
        }
        return this.extraAlpha == ac.extraAlpha;
    }

    public float getAlpha() {
        return this.extraAlpha;
    }

    public static DVBAlphaComposite getInstance(int rule) {
        switch (rule) {
            case 1: {
                return Clear;
            }
            case 2: {
                return Src;
            }
            case 3: {
                return SrcOver;
            }
            case 4: {
                return DstOver;
            }
            case 5: {
                return SrcIn;
            }
            case 6: {
                return DstIn;
            }
            case 7: {
                return SrcOut;
            }
            case 8: {
                return DstOut;
            }
        }
        throw new IllegalArgumentException("unknown composite rule");
    }

    public static DVBAlphaComposite getInstance(int rule, float alpha) {
        if (alpha == 1.0f) {
            return DVBAlphaComposite.getInstance(rule);
        }
        return new DVBAlphaComposite(rule, alpha);
    }

    public int getRule() {
        return this.rule;
    }
}

