/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.navigation;

import com.sun.tv.si.SIManagerImpl;
import javax.tv.service.Service;
import javax.tv.service.navigation.FavoriteServicesName;
import javax.tv.service.navigation.ServiceFilter;

public final class PreferenceFilter
extends ServiceFilter {
    private FavoriteServicesName preference = null;

    public PreferenceFilter(FavoriteServicesName preference) {
        if (preference == null || preference.getName() == null) {
            throw new NullPointerException();
        }
        FavoriteServicesName[] list = PreferenceFilter.listPreferences();
        if (list == null) {
            throw new IllegalArgumentException("list of preferences doesn't exist");
        }
        for (int i = 0; i < list.length; ++i) {
            if (!preference.getName().equalsIgnoreCase(list[i].getName())) continue;
            this.preference = preference;
        }
        if (this.preference == null) {
            throw new IllegalArgumentException(preference.getName() + " not an existing preference");
        }
    }

    public static FavoriteServicesName[] listPreferences() {
        return SIManagerImpl.getFavoriteServicesNames();
    }

    public FavoriteServicesName getFilterValue() {
        return this.preference;
    }

    public boolean accept(Service service) {
        String theName = service.getName();
        if (theName == null) {
            throw new NullPointerException("accept: service.getName == null");
        }
        FavoriteServicesName[] names = SIManagerImpl.getFavoriteServices(this.preference.getName());
        if (names == null) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!theName.equalsIgnoreCase(names[i].getName())) continue;
            return true;
        }
        return false;
    }
}

