/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.service.navigation;

import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.navigation.ServiceFilter;

public final class LocatorFilter
extends ServiceFilter {
    private Locator[] locators;

    public LocatorFilter(Locator[] locators) throws InvalidLocatorException {
        if (locators == null) {
            throw new NullPointerException("LocatorFilter: locators = null");
        }
        SIManager manager = SIManager.createInstance();
        if (manager != null) {
            for (int i = 0; i < locators.length; ++i) {
                try {
                    if (manager.getService(locators[i]) != null) continue;
                    throw new InvalidLocatorException(locators[i]);
                }
                catch (Exception e) {
                    throw new InvalidLocatorException(locators[i]);
                }
            }
        }
        this.locators = locators;
    }

    public Locator[] getFilterValue() {
        return this.locators;
    }

    public boolean accept(Service service) {
        Locator theLocator = service.getLocator();
        if (theLocator == null) {
            throw new NullPointerException("accept: service locator == null");
        }
        for (int i = 0; i < this.locators.length; ++i) {
            if (theLocator != this.locators[i]) continue;
            return true;
        }
        return false;
    }
}

