/*
 * Decompiled with CFR 0.152.
 */
package javax.tv.carousel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.tv.carousel.CarouselFileChangeEvent;
import javax.tv.carousel.CarouselFileListener;
import javax.tv.carousel.FileWatcher;
import javax.tv.carousel.NotifyCarouselFileThread;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.locator.MalformedLocatorException;

public class CarouselFile
extends File {
    private Locator locator;
    private Vector listeners = new Vector();
    private FileWatcher fileWatcher = null;
    private static final String CarouselProtocol = "carousel:/";

    public CarouselFile(Locator locator) throws InvalidLocatorException, IOException {
        super(CarouselFile.CheckLocator(locator));
        this.locator = this.createLocator(locator.toExternalForm().substring(10));
    }

    public CarouselFile(String path) throws IOException {
        super(path);
        if (path == null) {
            throw new NullPointerException("Path is null");
        }
        if (!this.isAbsolute()) {
            throw new FileNotFoundException();
        }
        this.locator = this.createLocator(path);
    }

    public CarouselFile(CarouselFile dir, String name) throws IOException {
        this(dir.getPath(), name);
    }

    public CarouselFile(String path, String name) throws IOException {
        super(path, name);
        if (path == null || name == null) {
            throw new NullPointerException("null String");
        }
        if (!this.isAbsolute()) {
            throw new FileNotFoundException();
        }
        this.locator = this.createLocator(path + "/" + name);
    }

    private Locator createLocator(String path) throws IOException {
        try {
            if (path == null) {
                throw new IOException("CarouselFile can't have an empty path");
            }
            if (!this.exists()) {
                throw new IOException("CarouselFile doesn't exist " + this.getPath());
            }
            if (!this.canRead()) {
                throw new IOException("CarouselFile can't be read " + this.getPath());
            }
            return LocatorFactory.getInstance().createLocator(CarouselProtocol + path.replace('\\', '/'));
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private static String CheckLocator(Locator locator) throws InvalidLocatorException, IOException {
        if (locator == null) {
            throw new NullPointerException();
        }
        String pathname = locator.toExternalForm();
        if (pathname == null) {
            throw new InvalidLocatorException(locator, "Invalid Carousel File");
        }
        if (!pathname.toLowerCase().startsWith(CarouselProtocol)) {
            throw new InvalidLocatorException(locator, "Invalid Carousel File");
        }
        return pathname.substring(10).replace('/', '\\');
    }

    public String[] listDirectoryContents() throws IOException, SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.getPath());
        }
        return super.list();
    }

    public void addListener(CarouselFileListener listener) throws IOException, SecurityException {
        if (listener == null) {
            throw new NullPointerException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.getPath());
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
        if (this.fileWatcher == null) {
            this.fileWatcher = new FileWatcher(this);
            this.fileWatcher.start();
        }
    }

    public void removeListener(CarouselFileListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.removeElement(listener);
        if (this.listeners.size() == 0 && this.fileWatcher != null) {
            this.fileWatcher = null;
        }
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void refreshCache() throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(this.getPath());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        String externalForm = null;
        if (this.locator != null) {
            externalForm = this.locator.toExternalForm();
        }
        stream.writeObject(externalForm);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        String externalForm = (String)stream.readObject();
        if (externalForm != null) {
            try {
                this.locator = LocatorFactory.getInstance().createLocator(externalForm);
            }
            catch (MalformedLocatorException ex) {
                throw new IOException(ex.toString());
            }
        }
    }

    void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        CarouselFileChangeEvent event = new CarouselFileChangeEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            CarouselFileListener listener = (CarouselFileListener)this.listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    private void notifyAsyncListener(CarouselFileChangeEvent event, CarouselFileListener listener) {
        if (listener == null || event == null) {
            return;
        }
        NotifyCarouselFileThread thread = new NotifyCarouselFileThread(event, listener);
        if (thread != null) {
            thread.start();
        }
    }
}

