/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import javax.media.Controller;
import javax.media.ControllerEvent;

public class TransitionEvent
extends ControllerEvent {
    int previousState;
    int currentState;
    int targetState;

    public TransitionEvent(Controller from, int previous, int current, int target) {
        super(from);
        this.previousState = previous;
        this.currentState = current;
        this.targetState = target;
    }

    public int getPreviousState() {
        return this.previousState;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int getTargetState() {
        return this.targetState;
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.eventSrc + ",previous=" + TransitionEvent.stateName(this.previousState) + ",current=" + TransitionEvent.stateName(this.currentState) + ",target=" + TransitionEvent.stateName(this.targetState) + "]";
    }

    static String stateName(int state) {
        switch (state) {
            case 100: {
                return "Unrealized";
            }
            case 200: {
                return "Realizing";
            }
            case 300: {
                return "Realized";
            }
            case 400: {
                return "Prefetching";
            }
            case 500: {
                return "Prefetched";
            }
            case 600: {
                return "Started";
            }
        }
        return "<Unknown>";
    }
}

