/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.NameCompare;
import com.sun.tv.si.NumberCompare;
import com.sun.tv.si.ServiceIteratorImpl;
import com.sun.tv.util.QuickSort;
import java.util.Vector;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.Service;
import javax.tv.service.navigation.ServiceFilter;
import javax.tv.service.navigation.ServiceIterator;
import javax.tv.service.navigation.ServiceList;
import javax.tv.service.navigation.SortNotAvailableException;

public class ServiceListImpl
implements ServiceList {
    Vector services;

    public ServiceListImpl(Service[] list) {
        this.services = new Vector();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this.services.addElement(list[i]);
            }
        }
    }

    public ServiceListImpl(Vector list) {
        this.services = list != null ? list : new Vector();
    }

    private boolean equals(Service s1, Service s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.getName().equalsIgnoreCase(s2.getName());
    }

    public ServiceList sortByName() {
        if (this.services == null || this.services.size() == 0) {
            return new ServiceListImpl(new Service[0]);
        }
        Object[] o = new Object[this.services.size()];
        for (int i = 0; i < o.length; ++i) {
            o[i] = this.services.elementAt(i);
        }
        QuickSort.sort(o, new NameCompare());
        Service[] s = new Service[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = (Service)o[i];
        }
        return new ServiceListImpl(s);
    }

    public ServiceList sortByNumber() throws SortNotAvailableException {
        if (this.services == null || this.services.size() == 0) {
            return new ServiceListImpl(new Service[0]);
        }
        Object[] o = new Object[this.services.size()];
        for (int i = 0; i < o.length; ++i) {
            o[i] = this.services.elementAt(i);
        }
        QuickSort.sort(o, new NumberCompare());
        Service[] s = new Service[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = (Service)o[i];
        }
        return new ServiceListImpl(s);
    }

    public Service findService(Locator locator) throws InvalidLocatorException {
        if (locator == null) {
            throw new NullPointerException();
        }
        if (!LocatorImpl.isService(locator)) {
            throw new InvalidLocatorException(locator);
        }
        String ef = locator.toExternalForm();
        for (int i = this.services.size() - 1; i >= 0; --i) {
            Service service = (Service)this.services.elementAt(i);
            if (!ef.equalsIgnoreCase(service.getLocator().toExternalForm())) continue;
            return service;
        }
        return null;
    }

    public ServiceList filterServices(ServiceFilter filter) {
        int count = 0;
        for (int i = 0; i < this.services.size(); ++i) {
            Service service = (Service)this.services.elementAt(i);
            if (filter != null && !filter.accept(service)) continue;
            ++count;
        }
        Service[] list = new Service[count];
        count = 0;
        for (int i = 0; i < this.services.size(); ++i) {
            Service service = (Service)this.services.elementAt(i);
            if (filter != null && !filter.accept(service)) continue;
            list[count++] = service;
        }
        return new ServiceListImpl(list);
    }

    public ServiceIterator createServiceIterator() {
        return new ServiceIteratorImpl(this.services);
    }

    public boolean contains(Service service) {
        if (service == null) {
            throw new NullPointerException();
        }
        return this.indexOf(service) != -1;
    }

    public int indexOf(Service service) {
        if (service == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.services.size(); ++i) {
            if (!this.equals((Service)this.services.elementAt(i), service)) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.services.size();
    }

    public Service getService(int index) {
        if (index < 0 || index >= this.services.size()) {
            throw new IndexOutOfBoundsException("index < 0 || index >= " + this.services.size());
        }
        return (Service)this.services.elementAt(index);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServiceList)) {
            return false;
        }
        ServiceList list = (ServiceList)o;
        if (list.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getService(i).equals(list.getService(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        for (int i = 0; i < this.size(); ++i) {
            hashcode ^= this.getService(i).hashCode();
        }
        return hashcode;
    }
}

