/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.Service;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.guide.ProgramEvent;
import javax.tv.service.navigation.ServiceComponent;
import javax.tv.service.navigation.StreamType;

public class ServiceComponentImpl
implements ServiceComponent {
    private String name = null;
    private StreamType streamType = null;
    private String language = null;
    private Service service = null;
    private Date updatedTime;
    private Locator locator = null;
    private ServiceInformationType siType;
    private ProgramEvent program = null;
    private boolean autorun = true;
    private int selectionFailedReason = 0;

    public ServiceComponentImpl(String name, String language, StreamType streamType, Service service, ProgramEvent program, ServiceInformationType siType, boolean autorun, Date updatedTime) {
        this.name = name;
        this.streamType = streamType;
        this.service = service;
        this.program = program;
        this.siType = siType;
        this.autorun = autorun;
        this.updatedTime = updatedTime;
        this.language = language != null && language.length() > 3 ? new String(language.getBytes(), 0, 3) : language;
    }

    public String getName() {
        return this.name;
    }

    public String getAssociatedLanguage() {
        return this.language == null ? "" : this.language;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public Service getService() {
        return this.service;
    }

    public Locator getLocator() {
        if (this.locator != null) {
            return this.locator;
        }
        try {
            String locatorStr = "component:/" + this.name + "service:/" + this.service.getName();
            this.locator = LocatorFactory.getInstance().createLocator(locatorStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.locator;
    }

    public Date getUpdateTime() {
        return this.updatedTime;
    }

    public ServiceInformationType getServiceInformationType() {
        return this.siType;
    }

    public ProgramEvent getProgramEvent() {
        return this.program;
    }

    public boolean isAutoRun() {
        return this.autorun;
    }

    public void setSelectionFailedReason(int reason) {
        this.selectionFailedReason = reason;
    }

    public int getSelectionFailedReason() {
        return this.selectionFailedReason;
    }
}

