/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.receiver.Settings;
import com.sun.tv.si.NetworkImpl;
import com.sun.tv.si.ProgramEventImpl;
import com.sun.tv.si.SIManagerImpl;
import com.sun.tv.si.ServiceComponentImpl;
import com.sun.tv.si.TransportStreamImpl;
import javax.tv.locator.Locator;
import javax.tv.service.SIElement;
import javax.tv.service.SIManager;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestFailureType;
import javax.tv.service.SIRequestor;
import javax.tv.service.SIRetrievable;

public class SIRequestImpl
implements SIRequest {
    long requestTime = System.currentTimeMillis();
    SIRequestor requestor = null;
    Locator locator = null;
    int requestKind = 0;
    Object[] userData = null;

    public SIRequestImpl(SIRequestor requestor, Locator locator) {
        this.requestor = requestor;
        this.locator = locator;
        this.requestKind = 0;
        this.userData = null;
        ((SIManagerImpl)SIManager.createInstance()).makeRequest(this);
    }

    public SIRequestImpl(SIRequestor requestor, Locator locator, int requestKind) {
        this.requestor = requestor;
        this.locator = locator;
        this.requestKind = requestKind;
        this.userData = null;
        ((SIManagerImpl)SIManager.createInstance()).makeRequest(this);
    }

    public SIRequestImpl(SIRequestor requestor, Locator locator, int requestKind, Object userData) {
        this.requestor = requestor;
        this.locator = locator;
        this.requestKind = requestKind;
        this.userData = new Object[1];
        this.userData[0] = userData;
        ((SIManagerImpl)SIManager.createInstance()).makeRequest(this);
    }

    public SIRequestImpl(SIRequestor requestor, Locator locator, int requestKind, Object userData1, Object userData2) {
        this.requestor = requestor;
        this.locator = locator;
        this.requestKind = requestKind;
        this.userData = new Object[2];
        this.userData[0] = userData1;
        this.userData[1] = userData2;
        ((SIManagerImpl)SIManager.createInstance()).makeRequest(this);
    }

    public SIRequestImpl(SIRequestor requestor, Locator locator, int requestKind, Object[] userData) {
        this.requestor = requestor;
        this.locator = locator;
        this.requestKind = requestKind;
        this.userData = userData;
        ((SIManagerImpl)SIManager.createInstance()).makeRequest(this);
    }

    public Locator getLocator() {
        return this.locator;
    }

    public int getRequestKind() {
        return this.requestKind;
    }

    public Object getUserData(int slot) {
        if (slot < 0 || slot >= this.userData.length) {
            return null;
        }
        return this.userData[slot];
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.requestTime > Settings.REQUEST_DURATION;
    }

    public void notifySuccess(SIRetrievable[] result) {
        this.requestor.notifySuccess(result);
    }

    public void notifyFailure(SIRequestFailureType reason) {
        this.requestor.notifyFailure(reason);
    }

    public boolean cancel() {
        return ((SIManagerImpl)SIManager.createInstance()).cancel(this);
    }

    public boolean equals(SIElement element) {
        switch (this.requestKind) {
            default: {
                String locatorStr2 = this.locator.toExternalForm();
                if (LocatorImpl.isSameProtocol(element.getLocator(), this.locator) && locatorStr2.endsWith(":/*")) {
                    return true;
                }
                return LocatorImpl.equals(element.getLocator(), this.locator);
            }
            case 1: {
                String serviceName2;
                if (!(element instanceof ServiceComponentImpl)) {
                    return false;
                }
                Locator locator1 = this.locator;
                Locator locator2 = element.getLocator();
                String serviceName1 = LocatorImpl.getServiceName(locator1);
                if (!this.equals(serviceName1, serviceName2 = LocatorImpl.getServiceName(locator2))) {
                    return false;
                }
                String compName1 = LocatorImpl.getServiceComponentName(locator1);
                String compName2 = LocatorImpl.getServiceComponentName(locator2);
                if (compName1 == null) {
                    return true;
                }
                return this.equals(compName1, compName2);
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                if (!(element instanceof ProgramEventImpl)) {
                    return false;
                }
                ProgramEventImpl pe = (ProgramEventImpl)element;
                Locator locator1 = this.locator;
                Locator locator2 = pe.getService().getLocator();
                String serviceName1 = LocatorImpl.getServiceName(locator1);
                String serviceName2 = LocatorImpl.getServiceName(locator2);
                return this.equals(serviceName1, serviceName2);
            }
            case 8: 
        }
        if (!(element instanceof TransportStreamImpl)) {
            return false;
        }
        TransportStreamImpl transportStream = (TransportStreamImpl)element;
        NetworkImpl network = (NetworkImpl)this.getUserData(0);
        return network != null && network.getNetworkID() == transportStream.getNetworkID();
    }

    private boolean equals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }
}

