/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.CacheManager;
import com.sun.tv.LocatorImpl;
import com.sun.tv.ReceiverListener;
import com.sun.tv.ServiceContextImpl;
import com.sun.tv.receiver.Settings;
import com.sun.tv.si.FavoriteServicesNameImpl;
import com.sun.tv.si.ProgramEventImpl;
import com.sun.tv.si.ProgramScheduleImpl;
import com.sun.tv.si.RatingDimensionImpl;
import com.sun.tv.si.SIRequestImpl;
import com.sun.tv.si.ServiceDetailsImpl;
import com.sun.tv.si.ServiceImpl;
import com.sun.tv.si.ServiceListImpl;
import com.sun.tv.si.TransportImpl;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.RatingDimension;
import javax.tv.service.ReadPermission;
import javax.tv.service.SIChangeEvent;
import javax.tv.service.SIChangeType;
import javax.tv.service.SIElement;
import javax.tv.service.SIException;
import javax.tv.service.SIManager;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestFailureType;
import javax.tv.service.SIRequestor;
import javax.tv.service.SIRetrievable;
import javax.tv.service.Service;
import javax.tv.service.guide.ProgramEvent;
import javax.tv.service.guide.ProgramScheduleEvent;
import javax.tv.service.navigation.DeliverySystemType;
import javax.tv.service.navigation.FavoriteServicesName;
import javax.tv.service.navigation.ServiceComponent;
import javax.tv.service.navigation.ServiceComponentChangeEvent;
import javax.tv.service.navigation.ServiceDetails;
import javax.tv.service.navigation.ServiceFilter;
import javax.tv.service.navigation.ServiceList;
import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.service.transport.Bouquet;
import javax.tv.service.transport.BouquetChangeEvent;
import javax.tv.service.transport.Network;
import javax.tv.service.transport.NetworkChangeEvent;
import javax.tv.service.transport.ServiceDetailsChangeEvent;
import javax.tv.service.transport.Transport;
import javax.tv.service.transport.TransportStream;
import javax.tv.service.transport.TransportStreamChangeEvent;

public class SIManagerImpl
extends SIManager
implements ReceiverListener,
Runnable {
    private String language = Settings.PreferredLanguage;
    private static Vector requests = new Vector();
    private static Vector newRequests = new Vector();
    private static Thread timeoutThread = null;
    private static Hashtable FavoriteServices = new Hashtable();
    private static Transport[] transports = new Transport[1];

    public static void putFavoriteServices(String localName, String[] shortNames) {
        if (shortNames == null || shortNames.length == 0) {
            return;
        }
        FavoriteServicesNameImpl[] list = new FavoriteServicesNameImpl[shortNames.length];
        for (int i = 0; i < shortNames.length; ++i) {
            list[i] = new FavoriteServicesNameImpl(shortNames[i]);
        }
        FavoriteServices.put(localName, list);
    }

    public static FavoriteServicesName[] getFavoriteServices(String localName) {
        return (FavoriteServicesName[])FavoriteServices.get(localName);
    }

    public static FavoriteServicesName[] getFavoriteServicesNames() {
        FavoriteServicesName[] list = new FavoriteServicesName[FavoriteServices.size()];
        int count = 0;
        Enumeration keys = FavoriteServices.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            list[count++] = new FavoriteServicesNameImpl(name);
        }
        return list;
    }

    public void setPreferredLanguage(String language) {
        if (language == null) {
            this.language = Settings.PreferredLanguage;
        }
        this.language = language;
    }

    public String getPreferredLanguage() {
        return this.language;
    }

    public void registerInterest(Locator locator, boolean active) throws InvalidLocatorException, SecurityException {
        if (locator == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        if (!LocatorImpl.isSIElement(locator)) {
            throw new InvalidLocatorException(locator, "Locator not referring to a valid SIElement");
        }
    }

    public String[] getSupportedDimensions() {
        return RatingDimensionImpl.getSupportedDimensions();
    }

    public RatingDimension getRatingDimension(String name) throws SIException {
        if (name == null) {
            throw new NullPointerException();
        }
        RatingDimension dimension = RatingDimensionImpl.getRatingDimension(name);
        if (dimension == null) {
            throw new SIException("Dimension " + name + " not found.");
        }
        return dimension;
    }

    public Transport[] getTransports() {
        return transports;
    }

    public SIRequest retrieveSIElement(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (locator == null || requestor == null) {
            throw new NullPointerException();
        }
        if (!LocatorImpl.validLocator(locator)) {
            throw new InvalidLocatorException(locator);
        }
        if (!LocatorImpl.isSIElement(locator)) {
            throw new InvalidLocatorException(locator);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        return new SIRequestImpl(requestor, locator);
    }

    public Service getService(Locator locator) throws InvalidLocatorException, SecurityException {
        if (locator == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        if (!LocatorImpl.isService(locator)) {
            throw new InvalidLocatorException(locator, locator.toExternalForm());
        }
        CacheManager serviceCache = CacheManager.getServiceCache();
        if (serviceCache == null) {
            throw new NullPointerException();
        }
        Object object = serviceCache.get(locator);
        if (!(object instanceof Service)) {
            throw new InvalidLocatorException(locator, locator.toExternalForm());
        }
        return (Service)object;
    }

    public SIRequest retrieveServiceDetails(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (locator == null || requestor == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        Locator detailsLoc = null;
        if (LocatorImpl.isTIService(locator)) {
            Locator[] locs = LocatorImpl.transformLocator(locator);
            if (locs != null && locs.length > 0) {
                detailsLoc = locs[0];
            }
        } else {
            detailsLoc = LocatorImpl.transformToService(locator);
        }
        if (detailsLoc == null || !LocatorImpl.isService(detailsLoc)) {
            throw new InvalidLocatorException(locator, locator.toExternalForm());
        }
        String detailsStr = detailsLoc.toExternalForm();
        if (detailsStr == null) {
            throw new InvalidLocatorException(locator, locator.toExternalForm());
        }
        return new SIRequestImpl(requestor, detailsLoc);
    }

    public SIRequest retrieveProgramEvent(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (locator == null || requestor == null) {
            throw new NullPointerException();
        }
        if (!LocatorImpl.isProgramEvent(locator)) {
            throw new InvalidLocatorException(locator);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        return new SIRequestImpl(requestor, locator);
    }

    public ServiceList filterServices(ServiceFilter filter) {
        Vector<Service> services = new Vector<Service>();
        CacheManager serviceCache = CacheManager.getServiceCache();
        if (serviceCache == null) {
            return new ServiceListImpl(services);
        }
        Enumeration list = serviceCache.elements();
        while (list.hasMoreElements()) {
            Object object = list.nextElement();
            if (!(object instanceof Service)) continue;
            Service service = (Service)object;
            if (filter != null && !filter.accept(service)) continue;
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(new ReadPermission(service.getLocator()));
                }
                services.addElement(service);
            }
            catch (Exception e) {}
        }
        return new ServiceListImpl(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRequest(SIRequestImpl request) {
        if (timeoutThread == null) {
            timeoutThread = new Thread((Runnable)this, "Request Timeout Thread");
            timeoutThread.start();
        }
        Vector vector = newRequests;
        synchronized (vector) {
            newRequests.addElement(request);
        }
    }

    public boolean hasPermission(Locator locator) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        try {
            sm.checkPermission(new ReadPermission(locator));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Vector findSIElements(SIRequestImpl request) {
        Vector<SIElement> results = new Vector<SIElement>();
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return results;
        }
        Enumeration elements = siCache.elements();
        block0 : switch (request.getRequestKind()) {
            default: {
                while (elements.hasMoreElements()) {
                    SIElement element = (SIElement)elements.nextElement();
                    if (!request.equals(element) || !this.hasPermission(element.getLocator())) continue;
                    results.addElement(element);
                }
                break;
            }
            case 3: {
                Date current = new Date(System.currentTimeMillis());
                while (elements.hasMoreElements()) {
                    ProgramEventImpl pe;
                    SIElement element = (SIElement)elements.nextElement();
                    if (!request.equals(element) || (pe = (ProgramEventImpl)element).compareTo(current) != 0L || !this.hasPermission(pe.getLocator())) continue;
                    results.addElement(element);
                    break block0;
                }
                break;
            }
            case 4: {
                Date futureDate = (Date)request.getUserData(0);
                while (elements.hasMoreElements()) {
                    ProgramEventImpl pe;
                    SIElement element = (SIElement)elements.nextElement();
                    if (!request.equals(element) || (pe = (ProgramEventImpl)element).compareTo(futureDate) != 0L || !this.hasPermission(pe.getLocator())) continue;
                    results.addElement(element);
                    break block0;
                }
                break;
            }
            case 5: {
                Date begDate = (Date)request.getUserData(0);
                Date endDate = (Date)request.getUserData(1);
                while (elements.hasMoreElements()) {
                    ProgramEventImpl pe;
                    SIElement element = (SIElement)elements.nextElement();
                    if (!request.equals(element) || !this.hasPermission((pe = (ProgramEventImpl)element).getLocator()) || pe.compareTo(begDate) < 0L || pe.compareTo(endDate) > 0L) continue;
                    results.addElement(element);
                }
                break;
            }
            case 7: {
                SIElement nextEvent = null;
                ProgramEvent curEvent = (ProgramEvent)request.getUserData(0);
                long nearest = Integer.MAX_VALUE;
                Date lastDate = curEvent.getEndTime();
                while (elements.hasMoreElements()) {
                    ProgramEventImpl pe;
                    long dt;
                    SIElement element = (SIElement)elements.nextElement();
                    if (!request.equals(element) || (dt = (pe = (ProgramEventImpl)element).compareTo(lastDate)) < 0L || dt >= nearest) continue;
                    nearest = dt;
                    nextEvent = pe;
                }
                if (nextEvent == null || !this.hasPermission(nextEvent.getLocator())) break;
                results.addElement(nextEvent);
                break;
            }
            case 8: {
                while (elements.hasMoreElements()) {
                    SIElement element = (SIElement)elements.nextElement();
                    if (!request.equals(element) || !this.hasPermission(element.getLocator())) continue;
                    results.addElement(element);
                }
                break block0;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(SIRequest toCancel) {
        Vector vector = requests;
        synchronized (vector) {
            for (int i = 0; i < requests.size(); ++i) {
                SIRequestImpl request = (SIRequestImpl)requests.elementAt(i);
                if (request != toCancel) continue;
                requests.removeElementAt(i);
                try {
                    request.notifyFailure(SIRequestFailureType.CANCELED);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    public boolean SIElementExists(SIElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Service) {
            CacheManager serviceCache = CacheManager.getServiceCache();
            if (serviceCache == null) {
                return false;
            }
            return serviceCache.containsKey(element.getLocator());
        }
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return false;
        }
        return siCache.containsKey(element.getLocator());
    }

    private void ReceiveSIElement(SIElement element) {
        if (element == null) {
            return;
        }
        if (element instanceof Service) {
            CacheManager serviceCache = CacheManager.getServiceCache();
            if (serviceCache == null) {
                return;
            }
            serviceCache.put(element.getLocator(), element);
        } else {
            CacheManager siCache = CacheManager.getSICache();
            if (siCache == null) {
                return;
            }
            siCache.put(element.getLocator(), element);
        }
    }

    private void RemoveSIElement(SIElement element) {
        if (element == null) {
            return;
        }
        if (element instanceof Service) {
            CacheManager serviceCache = CacheManager.getServiceCache();
            if (serviceCache == null) {
                return;
            }
            serviceCache.remove(element.getLocator());
        } else {
            CacheManager siCache = CacheManager.getSICache();
            if (siCache == null) {
                return;
            }
            siCache.remove(element.getLocator());
        }
    }

    private void TerminateService(SIElement element) {
        if (element == null || !(element instanceof ServiceImpl)) {
            return;
        }
        try {
            Locator serviceLoc;
            ServiceImpl service = (ServiceImpl)element;
            int reason = service.getPresentationTerminatedReason();
            if (reason == 0) {
                reason = 1;
            }
            if ((serviceLoc = service.getLocator()) == null) {
                throw new Exception("service locator is null");
            }
            ServiceContextFactory scf = ServiceContextFactory.getInstance();
            if (scf == null) {
                throw new Exception("service context factory is null");
            }
            ServiceContext[] contexts = scf.getServiceContexts();
            if (contexts == null) {
                throw new Exception("service contexts is null");
            }
            for (int i = 0; i < contexts.length; ++i) {
                ServiceContextImpl context = (ServiceContextImpl)contexts[i];
                Locator currentLoc = context.getServiceLocator();
                if (currentLoc == null || !LocatorImpl.equals(currentLoc, serviceLoc)) continue;
                context.stop0(reason);
            }
        }
        catch (Exception e) {
            System.out.println("TerminateService: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void NotifyRequestors(SIElement element) {
        Vector vector = requests;
        synchronized (vector) {
            for (int i = requests.size() - 1; i >= 0; --i) {
                SIRequestImpl request = (SIRequestImpl)requests.elementAt(i);
                Vector results = this.findSIElements(request);
                if (results.size() <= 0) continue;
                SIRetrievable[] response = new SIRetrievable[results.size()];
                for (int j = 0; j < results.size(); ++j) {
                    response[j] = (SIRetrievable)results.elementAt(j);
                }
                requests.removeElementAt(i);
                try {
                    request.notifySuccess(response);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void NotifyScheduleListeners(SIChangeEvent event) {
        if (event == null) {
            return;
        }
        SIElement element = event.getSIElement();
        if (element == null || !(element instanceof ProgramEvent)) {
            return;
        }
        Locator locator = element.getLocator();
        if (locator == null) {
            return;
        }
        if (!LocatorImpl.isProgramEvent(locator)) {
            return;
        }
        Locator detailsLoc = LocatorImpl.transformToService(locator);
        if (detailsLoc == null || !LocatorImpl.isService(detailsLoc)) {
            return;
        }
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        ServiceDetails details = (ServiceDetails)siCache.get(detailsLoc);
        if (details == null) {
            return;
        }
        ProgramScheduleImpl schedule = (ProgramScheduleImpl)details.getProgramSchedule();
        if (schedule == null) {
            return;
        }
        ProgramEvent pe = (ProgramEvent)event.getSIElement();
        SIChangeType ct = event.getChangeType();
        ProgramScheduleEvent pce = new ProgramScheduleEvent(schedule, ct, pe);
        schedule.notifyListeners(pce);
    }

    private void NotifyServiceDetailsListeners(SIChangeEvent event) {
        if (event == null) {
            return;
        }
        SIElement element = event.getSIElement();
        if (element == null || !(element instanceof ServiceDetails)) {
            return;
        }
        Locator locator = element.getLocator();
        if (locator == null) {
            return;
        }
        if (!LocatorImpl.isService(locator)) {
            return;
        }
        Locator detailsLoc = locator;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        ServiceDetails details = (ServiceDetails)siCache.get(detailsLoc);
        if (details == null) {
            return;
        }
        TransportImpl transport = (TransportImpl)transports[transports.length - 1];
        if (transport == null) {
            return;
        }
        SIChangeType ct = event.getChangeType();
        ServiceDetailsChangeEvent sdce = new ServiceDetailsChangeEvent((Transport)transport, ct, details);
        transport.notifyServiceDetailsListeners(sdce);
    }

    private void NotifyBouquetListeners(SIChangeEvent event) {
        if (event == null) {
            return;
        }
        SIElement element = event.getSIElement();
        if (element == null || !(element instanceof Bouquet)) {
            return;
        }
        TransportImpl transport = (TransportImpl)transports[transports.length - 1];
        if (transport == null) {
            return;
        }
        SIChangeType ct = event.getChangeType();
        BouquetChangeEvent sdce = new BouquetChangeEvent(transport, ct, (Bouquet)element);
        transport.notifyBouquetListeners(sdce);
    }

    private void NotifyNetworkListeners(SIChangeEvent event) {
        if (event == null) {
            return;
        }
        SIElement element = event.getSIElement();
        if (element == null || !(element instanceof Network)) {
            return;
        }
        TransportImpl transport = (TransportImpl)transports[transports.length - 1];
        if (transport == null) {
            return;
        }
        SIChangeType ct = event.getChangeType();
        NetworkChangeEvent sdce = new NetworkChangeEvent(transport, ct, (Network)element);
        transport.notifyNetworkListeners(sdce);
    }

    private void NotifyTransportStreamListeners(SIChangeEvent event) {
        if (event == null) {
            return;
        }
        SIElement element = event.getSIElement();
        if (element == null || !(element instanceof TransportStream)) {
            return;
        }
        TransportImpl transport = (TransportImpl)transports[transports.length - 1];
        if (transport == null) {
            return;
        }
        SIChangeType ct = event.getChangeType();
        TransportStreamChangeEvent sdce = new TransportStreamChangeEvent(transport, ct, (TransportStream)element);
        transport.notifyTransportStreamListeners(sdce);
    }

    private void NotifyServiceComponentListeners(SIChangeEvent event) {
        if (event == null) {
            return;
        }
        SIElement element = event.getSIElement();
        if (element == null || !(element instanceof ServiceComponent)) {
            return;
        }
        Locator locator = element.getLocator();
        if (locator == null) {
            return;
        }
        if (!LocatorImpl.isServiceComponent(locator)) {
            System.out.println("NotifyServiceComponentListeners: " + locator);
            return;
        }
        Locator detailsLoc = LocatorImpl.transformToService(locator);
        if (detailsLoc == null || !LocatorImpl.isService(detailsLoc)) {
            System.out.println("NotifyServiceComponentListeners: detialsLoc == null ");
            return;
        }
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            System.out.println("NotifyServiceComponentListeners: siCache == null ");
            return;
        }
        ServiceDetailsImpl details = (ServiceDetailsImpl)siCache.get(detailsLoc);
        if (details == null) {
            System.out.println("NotifyServiceComponentListeners: details == null ");
            return;
        }
        SIChangeType ct = event.getChangeType();
        ServiceComponentChangeEvent scce = new ServiceComponentChangeEvent((ServiceDetails)details, ct, (ServiceComponent)element);
        details.notifyListeners(scce);
    }

    public void notifyChange(SIChangeEvent event) {
        SIChangeType changeType = event.getChangeType();
        SIElement element = event.getSIElement();
        if (changeType == null) {
            return;
        }
        if (changeType.equals(SIChangeType.REMOVE)) {
            this.NotifyServiceDetailsListeners(event);
            this.NotifyServiceComponentListeners(event);
            this.NotifyBouquetListeners(event);
            this.NotifyNetworkListeners(event);
            this.NotifyTransportStreamListeners(event);
            this.NotifyScheduleListeners(event);
            this.TerminateService(element);
            this.RemoveSIElement(element);
        } else if (changeType.equals(SIChangeType.MODIFY)) {
            this.ReceiveSIElement(element);
            this.NotifyRequestors(element);
            this.NotifyServiceDetailsListeners(event);
            this.NotifyServiceComponentListeners(event);
            this.NotifyBouquetListeners(event);
            this.NotifyNetworkListeners(event);
            this.NotifyTransportStreamListeners(event);
            this.NotifyScheduleListeners(event);
        } else if (changeType.equals(SIChangeType.ADD)) {
            this.ReceiveSIElement(element);
            this.NotifyRequestors(element);
            this.NotifyServiceDetailsListeners(event);
            this.NotifyServiceComponentListeners(event);
            this.NotifyBouquetListeners(event);
            this.NotifyNetworkListeners(event);
            this.NotifyTransportStreamListeners(event);
            this.NotifyScheduleListeners(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewRequests() throws Exception {
        if (newRequests == null || newRequests.size() == 0) {
            return;
        }
        Vector vector = newRequests;
        synchronized (vector) {
            for (int i = 0; i < newRequests.size(); ++i) {
                SIRequestImpl request = (SIRequestImpl)newRequests.elementAt(i);
                if (request == null) continue;
                Vector results = this.findSIElements(request);
                if (results.size() > 0) {
                    SIRetrievable[] response = new SIRetrievable[results.size()];
                    for (int j = 0; j < results.size(); ++j) {
                        response[j] = (SIRetrievable)results.elementAt(j);
                    }
                    try {
                        request.notifySuccess(response);
                    }
                    catch (Exception e) {}
                    continue;
                }
                Vector vector2 = requests;
                synchronized (vector2) {
                    requests.addElement(request);
                    continue;
                }
            }
            newRequests.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldRequests() throws Exception {
        if (requests == null || requests.size() == 0) {
            return;
        }
        Vector vector = requests;
        synchronized (vector) {
            for (int i = requests.size() - 1; i >= 0; --i) {
                SIRequestImpl request = (SIRequestImpl)requests.elementAt(i);
                if (!request.isExpired()) continue;
                System.out.println("SIManagerImpl Expired: " + request.getLocator().toExternalForm());
                requests.removeElementAt(i);
                SIRequestFailureType reason = SIRequestFailureType.DATA_UNAVAILABLE;
                try {
                    request.notifyFailure(reason);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        int pollingInterval = 1000;
        while (true) {
            try {
                this.processNewRequests();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.removeOldRequests();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
    }

    static {
        if (transports[0] == null) {
            SIManagerImpl.transports[0] = new TransportImpl(1, DeliverySystemType.UNKNOWN);
        }
    }
}

