/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.si;

import com.sun.tv.LocatorImpl;
import com.sun.tv.si.NotifyProgramScheduleThread;
import com.sun.tv.si.SIRequestImpl;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.service.ReadPermission;
import javax.tv.service.SIException;
import javax.tv.service.SIRequest;
import javax.tv.service.SIRequestor;
import javax.tv.service.Service;
import javax.tv.service.guide.ProgramEvent;
import javax.tv.service.guide.ProgramSchedule;
import javax.tv.service.guide.ProgramScheduleEvent;
import javax.tv.service.guide.ProgramScheduleListener;

public class ProgramScheduleImpl
implements ProgramSchedule {
    Service service = null;
    private static Hashtable listenerTable = new Hashtable();

    public ProgramScheduleImpl(Service service) {
        this.service = service;
    }

    public SIRequest retrieveCurrentProgramEvent(SIRequestor requestor) {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        int reqKind = 3;
        return new SIRequestImpl(requestor, this.service.getLocator(), reqKind);
    }

    public SIRequest retrieveFutureProgramEvent(Date time, SIRequestor requestor) throws SIException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (time == null) {
            throw new NullPointerException("null Date");
        }
        if (!time.after(new Date())) {
            throw new SIException("not a future time value");
        }
        int reqKind = 4;
        return new SIRequestImpl(requestor, this.service.getLocator(), reqKind, time);
    }

    public SIRequest retrieveFutureProgramEvents(Date begin, Date end, SIRequestor requestor) throws SIException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (begin == null || end == null) {
            throw new NullPointerException("null date");
        }
        if (!end.after(new Date())) {
            throw new SIException("not a valid time value (end before current)");
        }
        if (end.before(begin)) {
            throw new SIException("not a valid time value (end before begin)");
        }
        int reqKind = 5;
        return new SIRequestImpl(requestor, this.service.getLocator(), reqKind, begin, end);
    }

    public SIRequest retrieveProgramEvent(Locator locator, SIRequestor requestor) throws InvalidLocatorException, SecurityException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (locator == null) {
            throw new NullPointerException("Locator null");
        }
        if (!LocatorImpl.isProgramEvent(locator)) {
            throw new InvalidLocatorException(locator);
        }
        if (!LocatorImpl.getServiceName(this.service.getLocator()).equals(LocatorImpl.getServiceName(locator))) {
            throw new InvalidLocatorException(locator, "not part of ProgramSchedule");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ReadPermission(locator));
        }
        return new SIRequestImpl(requestor, locator);
    }

    public void addListener(ProgramScheduleListener listener) {
        if (listener == null) {
            throw new NullPointerException("ProgramScheduleImpl: listener == null");
        }
        Vector listeners = this.getListeners();
        listeners.removeElement(listener);
        listeners.addElement(listener);
    }

    public void removeListener(ProgramScheduleListener listener) {
        if (listener == null) {
            throw new NullPointerException("ProgramScheduleImpl: listener == null");
        }
        Vector listeners = this.getListeners();
        listeners.removeElement(listener);
    }

    public SIRequest retrieveNextProgramEvent(ProgramEvent anEvent, SIRequestor requestor) throws SIException {
        if (requestor == null) {
            throw new NullPointerException("SIRequestor null");
        }
        if (anEvent == null) {
            throw new NullPointerException("ProgramEvent null");
        }
        if (!LocatorImpl.getServiceName(this.service.getLocator()).equals(LocatorImpl.getServiceName(anEvent.getLocator()))) {
            throw new SIException("Not a part of this ProgramSchedule");
        }
        int reqKind = 7;
        return new SIRequestImpl(requestor, this.service.getLocator(), reqKind, anEvent);
    }

    public Locator getServiceLocator() {
        return this.service.getLocator();
    }

    private Vector getListeners() {
        String key = this.service.getLocator().toExternalForm();
        Vector listeners = (Vector)listenerTable.get(key);
        if (listeners == null) {
            listeners = new Vector();
            listenerTable.put(key, listeners);
        }
        return listeners;
    }

    public void notifyListeners(ProgramScheduleEvent event) {
        Vector listeners = this.getListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            ProgramScheduleListener listener = (ProgramScheduleListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    private void notifyAsyncListener(ProgramScheduleEvent event, ProgramScheduleListener listener) {
        if (listener == null || event == null) {
            return;
        }
        NotifyProgramScheduleThread thread = new NotifyProgramScheduleThread(event, listener);
        if (thread != null) {
            thread.start();
        }
    }
}

