/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.receiver;

import com.sun.tv.receiver.SIEmulator;
import com.sun.tv.si.SIManagerImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Settings {
    public static final int REQ_GENERAL = 0;
    public static final int REQ_SERVICE_COMPONENT = 1;
    public static final int REQ_SERVICE_DESCRIPTION = 2;
    public static final int REQ_CURRENT_PROGRAM_EVENT = 3;
    public static final int REQ_FUTURE_PROGRAM_EVENT = 4;
    public static final int REQ_FUTURE_PROGRAM_EVENTS = 5;
    public static final int REQ_PROGRAM_EVENT = 6;
    public static final int REQ_NEXT_PROGRAM_EVENT = 7;
    public static final int REQ_TRANSPORT_STREAM = 8;
    public static long REQUEST_DURATION = 15000L;
    public static String PreferredLanguage = "eng";
    public static String[] ReceiverRatingNames = new String[2];
    public static String[] ReceiverRatingLevels = new String[2];
    public static String AWTVideoSizeControlClassName = "com.sun.tv.media.AWTVideoSizeControlImpl";
    public static String MediaSelectControlClassName = "com.sun.tv.media.MediaSelectControlImpl";
    public static String RootContainerClassName = "java.awt.Frame";
    public static String SampleClass = "SampleData_01";
    public static String SampleFile = "lib/JavaTVServiceFile.xml";
    public static int SampleInterval = 1000;
    public static String _defaultProperties = "lib/JavaTV.properties";
    public static int ContextServiceLimit = 50;

    public static void Load(String filename) {
        try {
            Properties p = new Properties();
            FileInputStream file = new FileInputStream(filename);
            p.load(file);
            SampleClass = p.getProperty("ServiceFileHandler", SampleClass);
            SampleFile = p.getProperty("ServiceFile", SampleFile);
            RootContainerClassName = p.getProperty("RootContainerClassName", RootContainerClassName);
            REQUEST_DURATION = Settings.getProperty(p, "RequestDuration", REQUEST_DURATION);
            PreferredLanguage = p.getProperty("PreferredLanguage", PreferredLanguage);
            ContextServiceLimit = Settings.getProperty(p, "ContextServiceLimit", ContextServiceLimit);
            Settings.loadProperty(p, "FavoriteServicesNames");
            file.close();
            System.out.println("ServiceFile: " + SampleClass);
        }
        catch (IOException e) {
            System.err.println("Could not load properties from file " + filename);
            e.printStackTrace();
        }
    }

    private static long toLong(String str) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private static long getProperty(Properties p, String key, long defaultValue) {
        String str = p.getProperty(key);
        return str == null ? defaultValue : Settings.toLong(str);
    }

    private static int getProperty(Properties p, String key, int defaultValue) {
        String str = p.getProperty(key);
        return str == null ? defaultValue : (int)Settings.toLong(str);
    }

    private static void loadProperty(Properties p, String key) {
        String str = p.getProperty(key);
        if (str == null) {
            return;
        }
        String[] strs = SIEmulator.toStrings(str, ",");
        if (strs == null || strs.length == 0) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String name = strs[i];
            String names = p.getProperty("List-" + name);
            if (names == null) continue;
            SIManagerImpl.putFavoriteServices(name, SIEmulator.toStrings(names, ","));
        }
    }

    static {
        Settings.ReceiverRatingNames[0] = "MPAA";
        Settings.ReceiverRatingLevels[0] = "Parental Guidance under 13";
        Settings.ReceiverRatingNames[1] = "YAMPAA";
        Settings.ReceiverRatingLevels[1] = "Phoney desc for D";
        Settings.Load(_defaultProperties);
    }
}

