/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.receiver;

import com.sun.tv.AppSignalEvent;
import com.sun.tv.CacheManager;
import com.sun.tv.DisplayManager;
import com.sun.tv.ReceiverListener;
import com.sun.tv.XletManager;
import com.sun.tv.media.protocol.service.PushSourceStream2Impl;
import com.sun.tv.receiver.SampleDataInterface;
import com.sun.tv.receiver.Settings;
import com.sun.tv.receiver.TimedObject;
import com.sun.tv.si.BouquetImpl;
import com.sun.tv.si.ContentRatingAdvisoryImpl;
import com.sun.tv.si.NetworkImpl;
import com.sun.tv.si.ProgramEventDescriptionImpl;
import com.sun.tv.si.ProgramEventImpl;
import com.sun.tv.si.SIChangeEventImpl;
import com.sun.tv.si.SIManagerImpl;
import com.sun.tv.si.ServiceComponentImpl;
import com.sun.tv.si.ServiceDescriptionImpl;
import com.sun.tv.si.ServiceDetailsImpl;
import com.sun.tv.si.ServiceImpl;
import com.sun.tv.si.TransportStreamImpl;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.SIChangeType;
import javax.tv.service.SIElement;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.ServiceType;
import javax.tv.service.guide.ProgramEvent;
import javax.tv.service.navigation.DeliverySystemType;
import javax.tv.service.navigation.ServiceComponent;
import javax.tv.service.navigation.ServiceDetails;
import javax.tv.service.navigation.StreamType;
import javax.tv.service.transport.Bouquet;
import javax.tv.service.transport.Network;
import javax.tv.service.transport.TransportStream;

public class SIEmulator
implements Runnable {
    private static Vector recvdQueue = new Vector();
    private static Thread emulatorThread = null;
    private static SIEmulator emulator = null;
    private static ReceiverListener listener = null;
    private static Hashtable services = new Hashtable();
    private static Hashtable programs = new Hashtable();
    private static SIManagerImpl siManager = null;
    private static SampleDataInterface dataInterface = null;

    public SIEmulator() {
        if (emulator == null) {
            emulator = this;
            siManager = (SIManagerImpl)SIManager.createInstance();
            listener = siManager;
            emulatorThread = new Thread((Runnable)this, "Emulator Thread");
            emulatorThread.start();
            PushSourceStream2Impl.registerServiceProtocol();
            com.sun.tv.media.protocol.component.PushSourceStream2Impl.registerComponentProtocol();
            this.runData(null);
        }
    }

    public static SIEmulator getInstance() {
        return emulator;
    }

    public boolean verify() {
        return dataInterface.verify();
    }

    public void runData(String[] args) {
        try {
            Object obj = Class.forName(Settings.SampleClass).newInstance();
            System.out.println("Running Data from Class = " + Settings.SampleClass);
            if (obj instanceof SampleDataInterface) {
                SampleDataInterface sd = (SampleDataInterface)obj;
                dataInterface = sd;
                sd.play(this, args);
                sd.finish();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void putService(long playTimeRel, String name, boolean hasMultiples, String sType, String siType, int serviceNumber, int minorNumber, String selectionFailedReason) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        ServiceImpl service = new ServiceImpl(name, hasMultiples, SIEmulator.toServiceType(sType), SIEmulator.toServiceInformationType(siType), serviceNumber, minorNumber, new Date(playTime));
        service.setSelectionFailedReason(SIEmulator.toSelectionFailedReason(selectionFailedReason));
        services.put(name, service);
        SIEmulator.put(playTime, service);
    }

    public static void putServiceDetails(long playTimeRel, String name, String providerName, DeliverySystemType deliveryType, String longname, String caSystemIDs) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        ServiceDetailsImpl serviceDetails = new ServiceDetailsImpl((ServiceImpl)services.get(name), providerName, deliveryType, longname, SIEmulator.toInts(caSystemIDs), new Date(playTime));
        SIEmulator.put(playTime, serviceDetails);
    }

    public static void putProgramSchedule(long playTimeRel, String servicename) {
    }

    public static void putProgramEvent(long playTimeRel, String programname, String servicename, long startTime, long duration, String siType, Vector dimensionNames, Vector ratingLongNames) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        int h = (int)((startTime - startTime % 100L) / 100L);
        int m = (int)(startTime % 100L);
        Date startDate = new Date(new Date().getTime() + (long)(h * 60 * 60 * 1000) + (long)(m * 60 * 1000));
        Date endDate = new Date(startDate.getTime() + (long)((int)((duration - duration % 100L) / 100L) * 60 * 60 * 1000) + (long)((int)(duration % 100L) * 60 * 1000));
        ContentRatingAdvisoryImpl advisory = new ContentRatingAdvisoryImpl(dimensionNames, ratingLongNames);
        ProgramEventImpl program = new ProgramEventImpl(programname, servicename, startDate, endDate, SIEmulator.toServiceInformationType(siType), advisory, new Date(playTime));
        programs.put(programname, program);
        SIEmulator.put(playTime, program);
    }

    public static void putProgramEventAbs(long playTimeRel, String programname, String servicename, long startTime, long duration, String siType, Vector dimensionNames, Vector ratingLongNames) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        Date startDate = new Date(startTime);
        Date endDate = new Date(startTime + duration * 60L * 1000L);
        ContentRatingAdvisoryImpl advisory = new ContentRatingAdvisoryImpl(dimensionNames, ratingLongNames);
        ProgramEventImpl program = new ProgramEventImpl(programname, servicename, startDate, endDate, SIEmulator.toServiceInformationType(siType), advisory, new Date(playTime));
        programs.put(programname, program);
        SIEmulator.put(playTime, program);
    }

    public static void putProgramEventDescription(long playTimeRel, String programname, String description) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        ProgramEventDescriptionImpl program = new ProgramEventDescriptionImpl((ProgramEvent)programs.get(programname), programname, description, new Date(playTime));
        SIEmulator.put(playTime, program);
    }

    public static void putServiceDescription(long playTimeRel, String name, String description) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        ServiceDescriptionImpl service = new ServiceDescriptionImpl((ServiceImpl)services.get(name), name, description, new Date(playTime));
        SIEmulator.put(playTime, service);
    }

    public static void putServiceComponent(long playTimeRel, String name, String language, StreamType streamType, String serviceName, String programName, String siType, boolean autorun, String selectionFailedReason) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        ProgramEvent program = null;
        if (programName != null) {
            program = (ProgramEvent)programs.get(programName);
        }
        ServiceComponentImpl component = new ServiceComponentImpl(name, language, streamType, (ServiceImpl)services.get(serviceName), program, SIEmulator.toServiceInformationType(siType), autorun, new Date(playTime));
        component.setSelectionFailedReason(SIEmulator.toSelectionFailedReason(selectionFailedReason));
        SIEmulator.put(playTime, component);
    }

    public static void putBouquet(long playTimeRel, String name, int bouquetID, String siType) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        BouquetImpl bouquet = new BouquetImpl(name, bouquetID, SIEmulator.toServiceInformationType(siType), new Date(playTime));
        SIEmulator.put(playTime, bouquet);
    }

    public static void putNetwork(long playTimeRel, String name, int networkID, String siType) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        NetworkImpl network = new NetworkImpl(name, networkID, SIEmulator.toServiceInformationType(siType), new Date(playTime));
        SIEmulator.put(playTime, network);
    }

    public static void putTransportStream(long playTimeRel, String description, int transportStreamID, String siType, int networkID) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        TransportStreamImpl transportStream = new TransportStreamImpl(description, transportStreamID, SIEmulator.toServiceInformationType(siType), new Date(playTime), networkID);
        SIEmulator.put(playTime, transportStream);
    }

    public static void putServiceXlet(String xletName, String xletPath, String argStr) {
        XletManager xletManager = XletManager.createInstance();
        DisplayManager dispManager = DisplayManager.createInstance();
        String[] args = SIEmulator.toStrings(argStr, ",");
        AppSignalEvent ase = new AppSignalEvent(dispManager.getRootFrame(), 2, null, xletPath, xletName, null, args);
        xletManager.signalReceived(ase);
    }

    public static boolean putXlet(long playTimeRel, String xletName, String xletPath, String[] args) {
        return SIEmulator.putResidentXlet(playTimeRel, xletName, xletPath, args);
    }

    public static boolean putResidentXlet(long playTimeRel, String xletName, String xletPath, String[] args) {
        long playTime = System.currentTimeMillis() + playTimeRel * 1000L;
        DisplayManager dispManager = DisplayManager.createInstance();
        AppSignalEvent ase = new AppSignalEvent(dispManager.getRootFrame(), 1, null, xletPath, xletName, null, args);
        SIEmulator.put(playTime, ase);
        return ase != null;
    }

    public static void RemoveSIElement(long playTimeRel, Locator locator) {
        if (locator == null) {
            return;
        }
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        SIElement element = (SIElement)siCache.get(locator);
        if (element == null) {
            return;
        }
        SIChangeEventImpl event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
        if (event == null) {
            return;
        }
        listener.notifyChange(event);
    }

    public static void RemoveSIDatabase(long playTimeRel, boolean genEvents) {
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            SIElement element = (SIElement)list.nextElement();
            if (element == null) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeService(long playTimeRel, String serviceName, String reason) {
        if (serviceName == null) {
            return;
        }
        SIEmulator.removeServiceTree(playTimeRel, serviceName);
        CacheManager serviceCache = CacheManager.getServiceCache();
        if (serviceCache == null) {
            return;
        }
        Locator locator = null;
        try {
            LocatorFactory factory = LocatorFactory.getInstance();
            locator = factory.createLocator("service:/" + serviceName);
        }
        catch (Exception e) {
            System.out.println("removeService exception: " + e);
            return;
        }
        ServiceImpl service = (ServiceImpl)serviceCache.get(locator);
        service.setPresentationTerminatedReason(SIEmulator.toPresentationTerminatedReason(reason));
        SIChangeEventImpl event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, service);
        listener.notifyChange(event);
    }

    public static void removeServiceTree(long playTimeRel, String serviceName) {
        if (serviceName == null) {
            return;
        }
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            Service service;
            SIElement element = (SIElement)list.nextElement();
            SIElement toDelete = null;
            if (element instanceof ProgramEvent) {
                ProgramEvent pe = (ProgramEvent)element;
                if (pe != null && (service = pe.getService()) != null && serviceName.equals(service.getName())) {
                    toDelete = element;
                }
            } else if (element instanceof ServiceComponent) {
                ServiceComponent sc = (ServiceComponent)element;
                if (sc != null && (service = sc.getService()) != null && serviceName.equals(service.getName())) {
                    toDelete = element;
                }
            } else {
                element = null;
            }
            if (toDelete == null) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, toDelete);
            listener.notifyChange(event);
        }
    }

    public static void removeProgramEvent(long playTimeRel, String serviceName, String programName) {
        if (serviceName == null || programName == null) {
            return;
        }
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            Service service;
            ProgramEvent pe;
            SIElement element = (SIElement)list.nextElement();
            if (element == null || !(element instanceof ProgramEvent) || !programName.equals((pe = (ProgramEvent)element).getName()) || (service = pe.getService()) == null || !serviceName.equals(service.getName())) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeBouquet(long playTimeRel, int bouquetID) {
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            Bouquet bouquet;
            SIElement element = (SIElement)list.nextElement();
            if (element == null || !(element instanceof Bouquet) || bouquetID != (bouquet = (Bouquet)element).getBouquetID()) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeNetwork(long playTimeRel, int networkID) {
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            Network network;
            SIElement element = (SIElement)list.nextElement();
            if (element == null || !(element instanceof Network) || networkID != (network = (Network)element).getNetworkID()) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeTransportStream(long playTimeRel, int transportStreamID) {
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            TransportStream transportStream;
            SIElement element = (SIElement)list.nextElement();
            if (element == null || !(element instanceof TransportStream) || transportStreamID != (transportStream = (TransportStream)element).getTransportStreamID()) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeServiceComponent(long playTimeRel, String componentName) {
        if (componentName == null) {
            return;
        }
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            ServiceComponent component;
            SIElement element = (SIElement)list.nextElement();
            if (element == null || !(element instanceof ServiceComponent) || !componentName.equals((component = (ServiceComponent)element).getName())) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeServiceDetails(long playTimeRel, String serviceName) {
        if (serviceName == null) {
            return;
        }
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            ServiceDetails details;
            SIElement element = (SIElement)list.nextElement();
            if (!(element instanceof ServiceDetails) || !serviceName.equals((details = (ServiceDetails)element).getService().getName())) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static void removeXlet(long playTimeRel, String xletName) {
        if (xletName == null) {
            return;
        }
        SIChangeEventImpl event = null;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration list = siCache.elements();
        while (list.hasMoreElements()) {
            AppSignalEvent ase;
            SIElement element = (SIElement)list.nextElement();
            if (!(element instanceof AppSignalEvent) || !xletName.equals((ase = (AppSignalEvent)((Object)element)).getClassName())) continue;
            event = new SIChangeEventImpl(emulator, SIChangeType.REMOVE, element);
            listener.notifyChange(event);
        }
    }

    public static DeliverySystemType toDeliverySystemType(String dstype) {
        if (dstype == null) {
            return DeliverySystemType.UNKNOWN;
        }
        if (dstype.equalsIgnoreCase(DeliverySystemType.SATELLITE.toString())) {
            return DeliverySystemType.SATELLITE;
        }
        if (dstype.equalsIgnoreCase(DeliverySystemType.CABLE.toString())) {
            return DeliverySystemType.CABLE;
        }
        if (dstype.equalsIgnoreCase(DeliverySystemType.TERRESTRIAL.toString())) {
            return DeliverySystemType.TERRESTRIAL;
        }
        return DeliverySystemType.UNKNOWN;
    }

    public static StreamType toStreamType(String stype) {
        StreamType[] stypes = new StreamType[]{StreamType.VIDEO, StreamType.AUDIO, StreamType.SUBTITLES, StreamType.DATA, StreamType.SECTIONS, StreamType.UNKNOWN};
        for (int i = 0; i < stypes.length; ++i) {
            if (!stype.equalsIgnoreCase(stypes[i].toString())) continue;
            return stypes[i];
        }
        return StreamType.UNKNOWN;
    }

    private static ServiceType toServiceType(String stype) {
        if (stype == null) {
            return ServiceType.UNKNOWN;
        }
        if (stype.equalsIgnoreCase(ServiceType.DIGITAL_TV.toString())) {
            return ServiceType.DIGITAL_TV;
        }
        if (stype.equalsIgnoreCase(ServiceType.DIGITAL_RADIO.toString())) {
            return ServiceType.DIGITAL_RADIO;
        }
        if (stype.equalsIgnoreCase(ServiceType.NVOD_REFERENCE.toString())) {
            return ServiceType.NVOD_REFERENCE;
        }
        if (stype.equalsIgnoreCase(ServiceType.NVOD_TIME_SHIFTED.toString())) {
            return ServiceType.NVOD_TIME_SHIFTED;
        }
        if (stype.equalsIgnoreCase(ServiceType.ANALOG_TV.toString())) {
            return ServiceType.ANALOG_TV;
        }
        if (stype.equalsIgnoreCase(ServiceType.ANALOG_RADIO.toString())) {
            return ServiceType.ANALOG_RADIO;
        }
        if (stype.equalsIgnoreCase(ServiceType.DATA_BROADCAST.toString())) {
            return ServiceType.DATA_BROADCAST;
        }
        if (stype.equalsIgnoreCase(ServiceType.DATA_APPLICATION.toString())) {
            return ServiceType.DATA_APPLICATION;
        }
        return ServiceType.UNKNOWN;
    }

    private static ServiceInformationType toServiceInformationType(String sitype) {
        if (sitype == null) {
            return ServiceInformationType.UNKNOWN;
        }
        if (sitype.equalsIgnoreCase(ServiceInformationType.ATSC_PSIP.toString())) {
            return ServiceInformationType.ATSC_PSIP;
        }
        if (sitype.equalsIgnoreCase(ServiceInformationType.DVB_SI.toString())) {
            return ServiceInformationType.DVB_SI;
        }
        if (sitype.equalsIgnoreCase(ServiceInformationType.SCTE_SI.toString())) {
            return ServiceInformationType.SCTE_SI;
        }
        return ServiceInformationType.UNKNOWN;
    }

    private static int toPresentationTerminatedReason(String reason) {
        if (reason == null) {
            return 0;
        }
        if (reason.equalsIgnoreCase("service_vanished")) {
            return 1;
        }
        if (reason.equalsIgnoreCase("tuned_away")) {
            return 2;
        }
        if (reason.equalsIgnoreCase("resources_removed")) {
            return 3;
        }
        if (reason.equalsIgnoreCase("access_withdrawn")) {
            return 4;
        }
        return 0;
    }

    private static int toSelectionFailedReason(String reason) {
        if (reason == null) {
            return 0;
        }
        if (reason.equalsIgnoreCase("interrupted")) {
            return 1;
        }
        if (reason.equalsIgnoreCase("ca_refusal")) {
            return 2;
        }
        if (reason.equalsIgnoreCase("content_not_found")) {
            return 3;
        }
        if (reason.equalsIgnoreCase("missing_handler")) {
            return 4;
        }
        if (reason.equalsIgnoreCase("tuning_failure")) {
            return 5;
        }
        if (reason.equalsIgnoreCase("insufficient_resources")) {
            return 6;
        }
        return 0;
    }

    private static int toInt(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static int[] toInts(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return null;
        }
        int count = 1;
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) != ',') continue;
            ++count;
        }
        int[] vals = new int[count];
        count = 0;
        int first = 0;
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) != ',') continue;
            if (first < i) {
                vals[count++] = SIEmulator.toInt(str.substring(first, i));
            }
            first = i + 1;
        }
        if (first < length) {
            vals[count++] = SIEmulator.toInt(str.substring(first).trim());
        }
        return vals;
    }

    public static String[] toStrings(String str, String delims) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return null;
        }
        int count = 1;
        for (int i = 0; i < length; ++i) {
            if (delims.indexOf(str.charAt(i)) == -1) continue;
            ++count;
        }
        String[] strs = new String[count];
        count = 0;
        int first = 0;
        for (int i = 0; i < length; ++i) {
            if (delims.indexOf(str.charAt(i)) == -1) continue;
            if (first < i) {
                strs[count++] = str.substring(first, i);
            }
            first = i + 1;
        }
        if (first < length) {
            strs[count++] = str.substring(first);
        }
        return strs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(long time, Object obj) {
        if (System.currentTimeMillis() >= time) {
            SIEmulator.Process(obj);
            return;
        }
        Vector vector = recvdQueue;
        synchronized (vector) {
            TimedObject tobj = new TimedObject(time, obj);
            recvdQueue.insertElementAt(tobj, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isCaughtUp() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector vector = recvdQueue;
        synchronized (vector) {
        }
    }

    private static void Process(Object object) {
        XletManager xletManager = XletManager.createInstance();
        try {
            if (object != null) {
                if (object instanceof SIElement) {
                    SIElement element = (SIElement)object;
                    SIChangeType ct = SIChangeType.ADD;
                    if (siManager.SIElementExists(element)) {
                        ct = SIChangeType.MODIFY;
                    }
                    SIChangeEventImpl event = new SIChangeEventImpl(emulator, ct, element);
                    listener.notifyChange(event);
                } else if (object instanceof AppSignalEvent) {
                    AppSignalEvent ase = (AppSignalEvent)object;
                    xletManager.signalReceived(ase);
                } else {
                    System.out.println("***Error: can't ProcessRecvdObjects = " + object);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProcessRecvdObjects(long sysdate) {
        Vector vector = recvdQueue;
        synchronized (vector) {
            for (int i = recvdQueue.size() - 1; i >= 0; --i) {
                TimedObject tobj = (TimedObject)recvdQueue.elementAt(i);
                if (sysdate < tobj.getDate()) continue;
                recvdQueue.removeElementAt(i);
                SIEmulator.Process(tobj.getObject());
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.ProcessRecvdObjects(System.currentTimeMillis());
                    Thread.sleep(1000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

