/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net.util;

import com.sun.tv.net.util.TimerThread;

public abstract class Timer {
    private static boolean debug = false;
    private static Timer timerHead;
    private static TimerThread timerThread;
    private Timer next;
    private Timer prev;
    private long expiry;
    private long startedAt;

    public abstract void callback(long var1);

    public boolean isStarted() {
        return this.expiry != 0L;
    }

    private void remove() {
        this.expiry = 0L;
        if (this == timerHead) {
            Timer.timerHead.prev = null;
            timerHead = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            if (this.isStarted()) {
                this.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long sleepTime) {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            if (this.isStarted()) {
                this.remove();
            }
            this.startedAt = System.currentTimeMillis();
            this.expiry = this.startedAt + sleepTime;
            if (timerHead != null) {
                Timer timer = timerHead;
                while (timer.expiry <= this.expiry) {
                    if (timer.next == null) {
                        timer.next = this;
                        this.prev = timer;
                        this.next = null;
                        return;
                    }
                    timer = timer.next;
                }
                this.next = timer;
                if (timer.prev == null) {
                    this.prev = null;
                    timerHead = this;
                    Timer.timerThread.notify();
                } else {
                    this.prev = timer.prev;
                    timer.prev.next = this;
                }
                timer.prev = this;
            } else {
                this.next = null;
                this.prev = null;
                timerHead = this;
                Timer.timerThread.notify();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doit() throws InterruptedException {
        Timer timer = null;
        long delta = 0L;
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            long time = System.currentTimeMillis();
            while (timerHead == null || Timer.timerHead.expiry > time) {
                long timeout = timerHead != null ? Timer.timerHead.expiry - time : 0L;
                Timer.timerThread.wait(timeout);
                time = System.currentTimeMillis();
            }
            timer = timerHead;
            timerHead = Timer.timerHead.next;
            if (timerHead != null) {
                Timer.timerHead.prev = null;
            }
            timer.expiry = 0L;
            delta = time - timer.startedAt;
        }
        timer.callback(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resyncTime(long delta) {
        TimerThread timerThread = Timer.timerThread;
        synchronized (timerThread) {
            Timer timer = timerHead;
            while (timer != null) {
                timer.expiry += delta;
                timer.startedAt += delta;
                timer = timer.next;
            }
        }
    }

    private static void dprint(String mess) {
        if (debug) {
            System.err.println("Timer: " + mess);
        }
    }

    static {
        timerThread = new TimerThread();
        timerThread.start();
    }
}

