/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net;

import com.sun.tv.net.Fragment;
import com.sun.tv.net.GenericPacket;
import com.sun.tv.net.IPReass;
import com.sun.tv.net.Packet;

class Reassembler {
    int src_ip;
    int dst_ip;
    int ident;
    int prot;
    int bytesQueued;
    int totalBytes;
    long timeout;
    Reassembler next;
    Reassembler prev;
    Fragment fragments;
    static final int numReassemblers = 5;
    private static Reassembler[] reassemblers = new Reassembler[5];
    private static Reassembler freeReassemblers;
    private static final int IP_MF = 8192;
    private static boolean debug;

    Reassembler() {
    }

    static Reassembler get(int ident, int src_ip, int dst_ip, int prot) {
        boolean enough_buffer = true;
        while (freeReassemblers == null) {
            enough_buffer = IPReass.recycleOldest();
            if (enough_buffer) continue;
            return null;
        }
        Reassembler reass = freeReassemblers;
        freeReassemblers = reass.next;
        reass.ident = ident;
        reass.src_ip = src_ip;
        reass.dst_ip = dst_ip;
        reass.prot = prot;
        reass.next = null;
        reass.prev = null;
        return reass;
    }

    void recycle() {
        while (this.fragments != null) {
            Fragment frag = this.fragments.next;
            this.fragments.recycle();
            this.fragments = frag;
        }
        this.totalBytes = 0;
        this.bytesQueued = 0;
        this.ident = 0;
        this.next = freeReassemblers;
        freeReassemblers = this;
    }

    private Packet combine() {
        GenericPacket pkt = GenericPacket.get(12, this.totalBytes);
        ((Packet)pkt).putInt(this.src_ip, -8);
        ((Packet)pkt).putInt(this.dst_ip, -4);
        while (this.fragments != null) {
            ((Packet)pkt).putBytes(this.fragments.pkt, 0, this.fragments.start_offset * 8, this.fragments.pkt.dataLength());
            Fragment frag = this.fragments.next;
            this.fragments.recycle();
            this.fragments = frag;
        }
        return pkt;
    }

    Packet add(Fragment new_frag, int start_offset) {
        boolean moreFragments = true;
        if ((start_offset & 0x2000) == 0) {
            moreFragments = false;
        }
        int len = new_frag.pkt.dataLength();
        new_frag.start_offset = start_offset & 0x1FFF;
        new_frag.end_offset = new_frag.start_offset + ((len + 7) / 8 - 1);
        if (this.fragments == null) {
            this.fragments = new_frag;
        } else if (new_frag.start_offset > this.fragments.start_offset) {
            new_frag.next = this.fragments;
            this.fragments = new_frag;
        } else {
            Fragment prev = null;
            Fragment frag = this.fragments;
            while (frag != null) {
                if (new_frag.end_offset >= frag.start_offset) {
                    if (new_frag.start_offset > frag.end_offset) {
                        prev.next = new_frag;
                        new_frag.next = frag;
                        break;
                    }
                    new_frag.recycle();
                    return null;
                }
                prev = frag;
                frag = frag.next;
            }
        }
        if (!moreFragments) {
            this.totalBytes = new_frag.start_offset * 8 + len;
        }
        this.bytesQueued += len;
        if (this.bytesQueued == this.totalBytes) {
            return this.combine();
        }
        return null;
    }

    private static void dprint(String s) {
        if (debug) {
            Reassembler.err(s);
        }
    }

    private static void err(String s) {
        System.err.println("Reassembler: " + s);
    }

    static {
        Reassembler.reassemblers[0] = new Reassembler();
        for (int i = 0; i < 4; ++i) {
            Reassembler.reassemblers[i + 1] = new Reassembler();
            Reassembler.reassemblers[i].next = reassemblers[i + 1];
        }
        Reassembler.reassemblers[i].next = null;
        freeReassemblers = reassemblers[0];
        debug = false;
    }
}

