/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net;

import com.sun.tv.net.Packet;

public class GenericPacket
extends Packet {
    private byte[] buf;

    GenericPacket(int hlen, int dlen) {
        this.length = hlen + dlen;
        this.hdr_offset = hlen;
        this.buf = new byte[this.length];
    }

    public static GenericPacket get(int hlen, int dlen) {
        GenericPacket sp = new GenericPacket(hlen, dlen);
        return sp;
    }

    public void recycle() {
        if (this.buf == null) {
            throw new Error("GenericPacket already recycled!");
        }
        this.buf = null;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public Packet copy() {
        GenericPacket sp = GenericPacket.get(this.hdr_offset, this.dataLength());
        sp.putBytes(this.buf, 0, -this.hdr_offset, this.length);
        sp.src_ip = this.src_ip;
        sp.src_port = this.src_port;
        sp.dst_ip = this.dst_ip;
        return sp;
    }

    public int cksum(int offset, int len) {
        return 0;
    }

    public long getEthAddr(int off) {
        return (long)(this.buf[off += this.hdr_offset] & 0xFF) << 40 | (long)(this.buf[off + 1] & 0xFF) << 32 | (long)(this.buf[off + 2] & 0xFF) << 24 | (long)(this.buf[off + 3] & 0xFF) << 16 | (long)(this.buf[off + 4] & 0xFF) << 8 | (long)(this.buf[off + 5] & 0xFF);
    }

    public int getInt(int off) {
        return this.buf[off += this.hdr_offset] << 24 | (this.buf[off + 1] & 0xFF) << 16 | (this.buf[off + 2] & 0xFF) << 8 | this.buf[off + 3] & 0xFF;
    }

    public int getShort(int off) {
        return (this.buf[off += this.hdr_offset] & 0xFF) << 8 | this.buf[off + 1] & 0xFF;
    }

    public int getByte(int off) {
        return this.buf[this.hdr_offset + off] & 0xFF;
    }

    public void getBytes(int src_offset, byte[] dst, int dst_offset, int len) {
        System.arraycopy(this.buf, this.hdr_offset + src_offset, dst, dst_offset, len);
    }

    public void putEthAddr(long d, int off) {
        this.buf[off += this.hdr_offset] = (byte)(d >>> 40);
        this.buf[off + 1] = (byte)(d >> 32 & 0xFFL);
        this.buf[off + 2] = (byte)(d >> 24 & 0xFFL);
        this.buf[off + 3] = (byte)(d >> 16 & 0xFFL);
        this.buf[off + 4] = (byte)(d >> 8 & 0xFFL);
        this.buf[off + 5] = (byte)(d & 0xFFL);
    }

    public void putInt(int d, int off) {
        this.buf[off += this.hdr_offset] = (byte)(d >>> 24);
        this.buf[off + 1] = (byte)(d >> 16 & 0xFF);
        this.buf[off + 2] = (byte)(d >> 8 & 0xFF);
        this.buf[off + 3] = (byte)(d & 0xFF);
    }

    public void putShort(int d, int off) {
        this.buf[off += this.hdr_offset] = (byte)(d >> 8 & 0xFF);
        this.buf[off + 1] = (byte)(d & 0xFF);
    }

    public void putByte(int d, int off) {
        this.buf[this.hdr_offset + off] = (byte)(d & 0xFF);
    }

    public void putBytes(byte[] src, int src_offset, int dst_offset, int len) {
        System.arraycopy(src, src_offset, this.buf, dst_offset + this.hdr_offset, len);
    }

    public void putBytes(Packet pkt, int src_offset, int dst_offset, int len) {
        pkt.getBytes(src_offset, this.buf, dst_offset + this.hdr_offset, len);
    }
}

