/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net;

import com.sun.tv.LocatorImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.SourceTransferHandler;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.media.protocol.DataLostException;
import javax.tv.media.protocol.PushSourceStream2;

public class EncapIPStream
implements PushSourceStream2 {
    private SourceTransferHandler handler;
    private boolean transferData = false;
    private boolean open = false;
    private static final int MTU_LLCSNAP = 4080;
    private static final int MTU_no_LLCSNAP = 4074;
    private FileInputStream tmpFileStream;
    private boolean endOfStream = false;

    public EncapIPStream(Locator loc) throws InvalidLocatorException {
        try {
            File tmp;
            String fileStr = LocatorImpl.getMediaFile(loc);
            if (fileStr != null && fileStr.startsWith("file:/")) {
                fileStr = fileStr.substring(new String("file:/").length());
            }
            if (!(tmp = new File(fileStr)).canRead()) {
                throw new InvalidLocatorException(loc, "can not read file at locator");
            }
            this.tmpFileStream = new FileInputStream(tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidLocatorException(loc, "locator is not an valid file name");
        }
    }

    public static boolean isIPStreamLocator(Locator loc) {
        File tmp;
        String fileStr = LocatorImpl.getMediaFile(loc);
        if (fileStr != null && fileStr.startsWith("file:/")) {
            fileStr = fileStr.substring(new String("file:/").length());
        }
        return (tmp = new File(fileStr)).canRead() && tmp.isFile();
    }

    public int read(byte[] buffer, int offset, int length) {
        try {
            return this.readStream(buffer, offset, length);
        }
        catch (Exception ioe) {
            return 0;
        }
    }

    public int readStream(byte[] buffer, int offset, int length) throws IOException, DataLostException {
        System.out.println("EncapIPStream, readingStreamoffset=" + offset + "length=" + length);
        int bytesRead = this.tmpFileStream.read(buffer, offset, length);
        System.out.println("EncapIPStream, readingStreambytesRead=" + bytesRead);
        if (bytesRead == -1) {
            this.endOfStream = true;
        }
        return bytesRead;
    }

    public void setTransferHandler(SourceTransferHandler transferHandler) {
        this.handler = transferHandler;
    }

    public int getMinimumTransferSize() {
        return 4080;
    }

    public boolean endOfStream() {
        return this.endOfStream;
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor("Encapsulated_IP_DATAGRAM");
    }

    public long getContentLength() {
        return -1L;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    public synchronized void setTransfer(boolean transfer) {
        this.transferData = transfer;
    }

    public synchronized void setOpen(boolean open) {
        if (open && this.open) {
            return;
        }
        this.open = open;
        if (open) {
            new Thread(new StreamReadingThread(this)).start();
        }
    }

    public synchronized boolean getOpen() {
        return this.open;
    }

    class StreamReadingThread
    implements Runnable {
        private EncapIPStream stream;

        StreamReadingThread(EncapIPStream ipStream) {
            System.out.println("StreamReadingThread forming a new thread");
            this.stream = ipStream;
        }

        public void run() {
            while (EncapIPStream.this.open) {
                if (!EncapIPStream.this.transferData) continue;
                if (this.newData() && EncapIPStream.this.handler != null) {
                    EncapIPStream.this.handler.transferData(this.stream);
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private boolean newData() {
            return true;
        }
    }
}

