/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.net;

import com.sun.tv.net.IPReass;
import com.sun.tv.net.Packet;
import com.sun.tv.net.PacketDiscardedException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class EncapIP {
    private static final int IPVERSION = 4;
    private static final int MIN_HEADER_LEN = 20;
    private static final int MAX_HEADER_LEN = 20;
    protected static final int IPPROTO_ICMP = 1;
    protected static final int IPPROTO_IGMP = 2;
    protected static final int IPPROTO_TCP = 6;
    protected static final int IPPROTO_UDP = 17;
    protected static final int IP_CLASSD_ADDR = -536870912;
    protected static final int IP_CLASSD_MASK = -268435456;
    private static final int VERS_OFFSET = 0;
    private static final int TOS_OFFSET = 1;
    private static final int LEN_OFFSET = 2;
    private static final int IDENT_OFFSET = 4;
    private static final int FRAG_OFFSET = 6;
    private static final int TTL_OFFSET = 8;
    private static final int PROT_OFFSET = 9;
    private static final int CKSUM_OFFSET = 10;
    static final int SRCIP_OFFSET = 12;
    static final int DSTIP_OFFSET = 16;
    private static final int IP_MF = 8192;
    private static final int IP_DF = 16384;
    private static final int UDP_SRCPORT_OFFSET = 0;
    private static final int UDP_DSTPORT_OFFSET = 2;
    private static final int SECTION_SYNTAX_INDICATOR_BIT = 9;
    private static final int PAYLOAD_SCRAMBLING_START_BIT = 43;
    private static final int PAYLOAD_SCRAMBLING_NO_BITS = 2;
    private static final int ADDRESS_SCRAMBLING_START_BIT = 45;
    private static final int ADDRESS_SCRAMBLING_NO_BITS = 2;
    private static final int LLC_SNAP_FLAG_BIT = 47;
    private static final int LLC_SNAP_HDR_BYTE_OFFSET = 12;
    private static final int LLC_SNAP_HDR_BYTE_LEN = 4;
    private static final int IP_DATAGRAM_BYTE_OFFSET_LLC = 16;
    private static final int IP_DATAGRAM_BYTE_OFFSET_NO_LLC = 12;
    private static final int CKSUM_OR_CRC_BYTE_LEN = 4;
    private static final int ENCAP_HEADER_LEN = 12;
    private int section_syntax_indicator;
    private int LLC_SNAP;
    private static boolean debug = false;

    private static int getBits(int bit_offset, int no_bits, Packet pkt) {
        if (no_bits > 2 || no_bits < 1) {
            return -1;
        }
        int byte_offset = bit_offset / 8;
        int leftover_bit_offset = bit_offset % 8;
        if (leftover_bit_offset > 0) {
            ++byte_offset;
        }
        int starting_byte = pkt.getByte(byte_offset - 1);
        if (no_bits == 1) {
            starting_byte >>= 8 - leftover_bit_offset;
            starting_byte &= 1;
        } else {
            starting_byte >>= 8 - leftover_bit_offset - 1;
            starting_byte &= 3;
        }
        return starting_byte;
    }

    public static boolean inputIP(Packet pkt, boolean mcast, int mcastAddr, int mcastPort, DatagramPacket dPkt) throws PacketDiscardedException {
        int dst_ip;
        int section_syntax_indicator = EncapIP.getBits(9, 1, pkt);
        int LLC_SNAP = EncapIP.getBits(47, 1, pkt);
        if (LLC_SNAP == 1) {
            pkt.shiftHeader(16);
            EncapIP.err("llc bit is 1, correct, pkt hdrlen=" + pkt.getHeaderOffset());
        } else if (LLC_SNAP == 0) {
            EncapIP.err("llc bit is 0, wrong!!");
            pkt.shiftHeader(12);
        } else {
            EncapIP.err("wrong llc snap bit");
        }
        int len = pkt.dataLength();
        if (len < 20) {
            EncapIP.err("Packet length too small: " + len);
            throw new PacketDiscardedException("Packet length too small: " + len);
        }
        int b = pkt.getByte(0);
        int version = b >>> 4;
        if (version != 4) {
            throw new PacketDiscardedException("bad header version: " + version);
        }
        int headerLength = (b & 0xF) * 4;
        if (headerLength != 20) {
            throw new PacketDiscardedException("bad header length: " + headerLength);
        }
        if (pkt.cksum(0, headerLength) != 0) {
            throw new PacketDiscardedException("header checksum error");
        }
        int packetLength = pkt.getShort(2);
        EncapIP.err("packetLength=" + packetLength + "len=" + len);
        if (packetLength > len) {
            throw new PacketDiscardedException("Packet too short");
        }
        if (packetLength < len) {
            pkt.setDataLength(packetLength);
        }
        if (((dst_ip = pkt.getInt(16)) & 0xF0000000) == -536870912 && mcast && dst_ip != mcastAddr) {
            throw new PacketDiscardedException("multicast address do not match");
        }
        int src_ip = pkt.getInt(12);
        int prot = pkt.getByte(9) & 0xFF;
        int offset = pkt.getShort(6);
        if ((src_ip & 0xF0000000) == -536870912) {
            throw new PacketDiscardedException("src addr = multicast addr");
        }
        if (prot != 17) {
            throw new PacketDiscardedException("protocol is not UDP");
        }
        pkt.shiftHeader(headerLength);
        int src_port = pkt.getShort(0);
        int dst_port = pkt.getShort(2);
        if (mcast && dst_port != mcastPort) {
            throw new PacketDiscardedException("multcast port does not match dst_port=" + dst_port + "mcastPort supposed to be=" + mcastPort);
        }
        pkt.src_port = src_port;
        pkt.src_ip = src_ip;
        if ((offset & 0x3FFF) != 0) {
            int id = pkt.getShort(4 - headerLength);
            if ((pkt = IPReass.insertFragment(pkt, id, src_ip, dst_ip, prot, offset)) == null) {
                throw new PacketDiscardedException("in the process of de-frag");
            }
            EncapIP.dprint("fragmented packets reassembled");
        }
        try {
            dPkt.setAddress(InetAddress.getByName(EncapIP.addrToString(pkt.src_ip)));
            dPkt.setPort(pkt.src_port);
            dPkt.setLength(packetLength);
            byte[] newBuf = new byte[packetLength];
            pkt.getBytes(pkt.getHeaderOffset(), newBuf, 0, packetLength);
            dPkt.setData(newBuf);
        }
        catch (UnknownHostException uhe) {
            throw new PacketDiscardedException("src_ip address is bad");
        }
        return true;
    }

    public static String addrToString(int addr) {
        return Integer.toString(addr >> 24 & 0xFF) + "." + Integer.toString(addr >> 16 & 0xFF) + "." + Integer.toString(addr >> 8 & 0xFF) + "." + Integer.toString(addr & 0xFF);
    }

    private static void dprint(String mess) {
        if (debug) {
            EncapIP.err(mess);
        }
    }

    private static void err(String mess) {
        System.err.println("EncapIP: " + mess);
    }
}

