/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.util;

import com.sun.tv.media.util.MediaThread;
import java.util.Vector;
import javax.media.ControllerEvent;

public abstract class ThreadedEventQueue
extends MediaThread {
    private Vector eventQueue = new Vector();
    private boolean killed = false;

    public ThreadedEventQueue() {
        this.useControlPriority();
    }

    protected abstract void processEvent(ControllerEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvents() {
        ControllerEvent evt = null;
        ThreadedEventQueue threadedEventQueue = this;
        synchronized (threadedEventQueue) {
            try {
                while (!this.killed && this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                System.err.println("MediaNode event thread " + e);
                return;
            }
            evt = (ControllerEvent)this.eventQueue.elementAt(0);
            this.eventQueue.removeElementAt(0);
        }
        if (evt != null) {
            this.processEvent(evt);
        }
    }

    public synchronized void postEvent(ControllerEvent evt) {
        this.eventQueue.addElement(evt);
        this.notifyAll();
    }

    public synchronized void kill() {
        this.killed = true;
        this.notifyAll();
    }

    public void run() {
        while (true) {
            this.dispatchEvents();
        }
    }
}

