/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media.util;

import com.sun.tv.media.util.MediaThread;

public abstract class LoopThread
extends MediaThread {
    protected boolean paused = false;
    protected boolean restarted = false;
    protected boolean killed = false;
    private boolean doneLastLoop = true;

    public LoopThread() {
        this.setName("Loop thread");
    }

    public synchronized void pause() {
        this.paused = true;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public synchronized void blockingPause() {
        if (this.paused) {
            return;
        }
        this.paused = true;
        this.doneLastLoop = false;
        try {
            if (this.paused && !this.doneLastLoop) {
                this.wait(250L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void restart() {
        this.paused = false;
        this.restarted = true;
        this.notifyAll();
    }

    public synchronized void kill() {
        this.killed = true;
        this.notifyAll();
    }

    public synchronized void waitHereIfPaused() {
        if (this.paused) {
            this.doneLastLoop = true;
            this.notifyAll();
        }
        try {
            while (!this.killed && this.paused) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            System.err.println("Timer: timeLoop() wait interrupted " + e);
        }
    }

    public abstract boolean process();

    public void doPause() {
    }

    public void doKilled() {
    }

    public void run() {
        while (true) {
            this.waitHereIfPaused();
            this.process();
            if (this.paused) {
                this.doPause();
            }
            if (!this.killed) continue;
            this.doKilled();
        }
    }
}

