/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media;

import com.sun.tv.media.MediaController;
import com.sun.tv.media.util.MediaThread;

class TimedStartThread
extends MediaThread {
    private MediaController controller;
    private long timeToStart;
    private boolean aborted = false;

    TimedStartThread(MediaController mc, long tbt) {
        this.controller = mc;
        this.timeToStart = tbt;
        this.useControlPriority();
    }

    public synchronized void abort() {
        this.aborted = true;
        this.notifyAll();
    }

    public synchronized void run() {
        if (this.aborted) {
            return;
        }
        if (this.controller.getState() != 600) {
            return;
        }
        long now = this.controller.getTimeBase().getNanoseconds();
        if (now >= this.timeToStart) {
            this.controller.doStart();
            return;
        }
        long timeToSleep = (this.timeToStart - now) / 1000000L;
        try {
            this.wait(timeToSleep);
        }
        catch (InterruptedException e) {
            System.err.println("TimedStartThread: " + e);
        }
        if (!this.aborted) {
            this.controller.doStart();
        }
    }
}

