/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media;

import com.sun.tv.Handler;
import com.sun.tv.LocatorImpl;
import com.sun.tv.ServiceContextImpl;
import com.sun.tv.media.NotifyMediaSelectThread;
import java.awt.Component;
import java.util.Vector;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.media.MediaSelectCARefusedEvent;
import javax.tv.media.MediaSelectControl;
import javax.tv.media.MediaSelectEvent;
import javax.tv.media.MediaSelectFailedEvent;
import javax.tv.media.MediaSelectListener;
import javax.tv.media.MediaSelectPermission;
import javax.tv.media.MediaSelectSucceededEvent;
import javax.tv.service.selection.InsufficientResourcesException;
import javax.tv.service.selection.InvalidServiceComponentException;
import javax.tv.service.selection.PresentationTerminatedEvent;
import javax.tv.service.selection.SelectionFailedEvent;
import javax.tv.service.selection.ServiceContextDestroyedEvent;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextListener;

public class MediaSelectControlImpl
implements MediaSelectControl,
ServiceContextListener {
    private Vector listeners = null;
    private ServiceContextImpl context = null;
    private Handler handler = null;

    public MediaSelectControlImpl(Handler handler, ServiceContextImpl context) {
        this.context = context;
        this.handler = handler;
        try {
            context.addListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void select(Locator component) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        if (component == null) {
            throw new NullPointerException("Locator is null");
        }
        if (this.context == null) {
            throw new NullPointerException("context is null");
        }
        if (!LocatorImpl.isServiceComponent(component)) {
            throw new InvalidLocatorException(component);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MediaSelectPermission(component));
        }
        Locator[] components = new Locator[]{component};
        this.context.select(components);
    }

    public void select(Locator[] components) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        if (components == null) {
            throw new NullPointerException("Locator[] is null");
        }
        if (this.context == null) {
            throw new NullPointerException("context is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (int i = 0; i < components.length; ++i) {
                sm.checkPermission(new MediaSelectPermission(components[i]));
            }
        }
        this.context.select(components);
    }

    public synchronized void add(Locator component) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        if (component == null) {
            throw new NullPointerException("Locator is null");
        }
        if (this.context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.handler == null) {
            throw new NullPointerException("handler is null");
        }
        if (!LocatorImpl.isServiceComponent(component)) {
            throw new InvalidLocatorException(component);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MediaSelectPermission(component));
        }
        Locator[] current = this.handler.getServiceContentLocators();
        Locator[] components = null;
        if (current == null) {
            components = new Locator[]{component};
        } else {
            components = new Locator[current.length + 1];
            for (int i = 0; i < current.length; ++i) {
                components[i] = current[i];
            }
            components[current.length] = component;
        }
        this.context.select(components);
    }

    public void remove(Locator component) throws InvalidLocatorException, InvalidServiceComponentException, SecurityException {
        Locator[] current;
        if (component == null) {
            throw new NullPointerException("Locator is null");
        }
        if (this.context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.handler == null) {
            throw new NullPointerException("handler is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MediaSelectPermission(component));
        }
        if ((current = this.handler.getServiceContentLocators()) == null || current.length == 0) {
            throw new InvalidLocatorException(component, "Locator not found");
        }
        boolean found = false;
        for (int i = 0; i < current.length; ++i) {
            if (!component.equals(current[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidLocatorException(component, "Locator not found");
        }
        Locator[] components = new Locator[current.length - 1];
        int counter = 0;
        for (int i = 0; i < current.length; ++i) {
            if (component.equals(current[i])) continue;
            components[counter] = current[i];
            ++counter;
        }
        try {
            this.select(components);
        }
        catch (InsufficientResourcesException e) {
            throw new InvalidServiceComponentException(component);
        }
    }

    public void replace(Locator fromComponent, Locator toComponent) throws InvalidLocatorException, InvalidServiceComponentException, InsufficientResourcesException, SecurityException {
        Locator[] current;
        if (fromComponent == null || toComponent == null) {
            throw new NullPointerException("Locator is null");
        }
        if (this.context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.handler == null) {
            throw new NullPointerException("handler is null");
        }
        if (!LocatorImpl.isServiceComponent(fromComponent)) {
            throw new InvalidLocatorException(fromComponent);
        }
        if (!LocatorImpl.isServiceComponent(toComponent)) {
            throw new InvalidLocatorException(toComponent);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new MediaSelectPermission(fromComponent));
            sm.checkPermission(new MediaSelectPermission(toComponent));
        }
        if ((current = this.handler.getServiceContentLocators()) == null || current.length == 0) {
            throw new InvalidServiceComponentException(fromComponent, "Locator not found");
        }
        Locator[] components = new Locator[current.length];
        boolean found = false;
        for (int i = 0; i < current.length; ++i) {
            if (fromComponent.equals(current[i])) {
                components[i] = toComponent;
                found = true;
                continue;
            }
            components[i] = current[i];
        }
        if (!found) {
            throw new InvalidServiceComponentException(fromComponent, "Locator not found");
        }
        this.select(components);
    }

    public void addMediaSelectListener(MediaSelectListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaSelectListener is null");
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.removeElement(listener);
        this.listeners.addElement(listener);
    }

    public void removeMediaSelectListener(MediaSelectListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaSelectListener is null");
        }
        if (this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    public Locator[] getCurrentSelection() {
        if (this.handler == null) {
            return null;
        }
        return this.handler.getServiceContentLocators();
    }

    public Component getControlComponent() {
        return null;
    }

    public void receiveServiceContextEvent(ServiceContextEvent e) {
        MediaSelectEvent event = null;
        if (e instanceof PresentationTerminatedEvent) {
            event = new MediaSelectFailedEvent(this.handler, this.handler.getServiceContentLocators());
        } else if (e instanceof SelectionFailedEvent) {
            SelectionFailedEvent sfe = (SelectionFailedEvent)e;
            event = sfe.getReason() == 2 ? new MediaSelectCARefusedEvent(this.handler, this.handler.getServiceContentLocators()) : new MediaSelectFailedEvent(this.handler, this.handler.getServiceContentLocators());
        } else {
            event = e instanceof ServiceContextDestroyedEvent ? new MediaSelectFailedEvent(this.handler, this.handler.getServiceContentLocators()) : new MediaSelectSucceededEvent(this.handler, this.handler.getServiceContentLocators());
        }
        this.notifyListeners(event);
    }

    private synchronized void notifyListeners(MediaSelectEvent event) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            MediaSelectListener listener = (MediaSelectListener)this.listeners.elementAt(i);
            this.notifyAsyncListener(event, listener);
        }
    }

    private void notifyAsyncListener(MediaSelectEvent event, MediaSelectListener listener) {
        if (listener == null || event == null) {
            return;
        }
        NotifyMediaSelectThread thread = new NotifyMediaSelectThread(event, listener);
        if (thread != null) {
            thread.start();
        }
    }
}

