/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media;

import com.sun.tv.media.GainControlAdapter;
import com.sun.tv.media.MediaController;
import com.sun.tv.media.SystemTimeBase;
import com.sun.tv.media.util.JMFI18N;
import com.sun.tv.media.util.JMFProperties;
import com.sun.tv.media.util.JMFSecurity;
import com.sun.tv.media.util.MediaThread;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Vector;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;

public abstract class MediaPlayer
extends MediaController
implements Player,
GainChangeListener {
    public static String VERSION = JMFI18N.getResource("mediaplayer.version");
    protected DataSource source = null;
    private Time duration = Duration.DURATION_UNKNOWN;
    private Vector nodeList = null;
    private Vector internalNodeList = null;
    private Vector optionalNodeList = new Vector();
    private Vector removedNodeList = new Vector();
    private Vector currentNodeList = new Vector();
    private Vector potentialEventsList = null;
    private Vector receivedEventList = new Vector();
    private boolean receivedAllEvents = false;
    private Vector realizeEventList = new Vector();
    private Vector prefetchEventList = new Vector();
    private Vector stopEventList = new Vector();
    private boolean waitingForRealizeCompleteEvent = false;
    private boolean waitingForPrefetchCompleteEvent = false;
    private boolean deallocated = false;
    private ControllerEvent realizeCompletionEvent = null;
    private ControllerEvent prefetchCompletionEvent = null;
    private ControllerEvent CachingControlEvent = null;
    private Controller restartFrom = null;
    private Vector eomEventsReceivedFrom = new Vector();
    private PlayThread playThread = null;
    private Time startTime;
    private Time mediaTimeAtStart;
    protected static TimeBase systemTimeBase;
    protected Control[] controls = null;
    protected GainControl gainControl = null;
    private Integer mediaTimeSync;
    public static ColorModel defaultColorModel;
    long lastTime = 0L;

    public MediaPlayer() {
        if (defaultColorModel == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            defaultColorModel = tk.getColorModel();
        }
        this.nodeList = new Vector();
        this.realizeEventList.addElement("javax.media.RealizeCompleteEvent");
        this.realizeEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.prefetchEventList.addElement("javax.media.PrefetchCompleteEvent");
        this.prefetchEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.stopEventList.addElement("javax.media.StopEvent");
        this.stopEventList.addElement("javax.media.StopByRequestEvent");
        this.stopEventList.addElement("javax.media.StopAtTimeEvent");
        this.mediaTimeSync = new Integer(1);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PullDataSource)) {
            System.out.println("Unsupported data source: " + source);
            System.out.println(this + " currently supports only pull data sources.");
            throw new IncompatibleSourceException(this + ": doesn't support " + source);
        }
        this.source = source;
    }

    protected DataSource getSource() {
        return this.source;
    }

    public final void close() {
        if (this.nodeList != null) {
            while (!this.nodeList.isEmpty()) {
                Controller c = (Controller)this.nodeList.firstElement();
                c.close();
                this.nodeList.removeElement(c);
            }
        }
        super.close();
    }

    protected void doClose() {
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        if (tb == null) {
            tb = this.getMasterTimeBase();
        }
        super.setTimeBase(tb);
        if (this.nodeList == null) {
            return;
        }
        int i = this.nodeList.size();
        while (--i >= 0) {
            ((Controller)this.nodeList.elementAt(i)).setTimeBase(tb);
        }
    }

    protected void setMediaLength(long t) {
        this.duration = new Time(t);
        super.setMediaLength(t);
    }

    public Time getDuration() {
        if ((long)this.getMediaTime().getSeconds() > this.lastTime) {
            this.lastTime = (long)this.getMediaTime().getSeconds();
            this.updateDuration();
        }
        if (this.duration.getSeconds() <= 0.0) {
            return Duration.DURATION_UNKNOWN;
        }
        return this.duration;
    }

    protected synchronized void updateDuration() {
        Time dur;
        Controller c;
        int i;
        if (this.internalNodeList == null) {
            return;
        }
        if (this.duration.getSeconds() <= 0.0) {
            this.duration = Duration.DURATION_UNKNOWN;
        }
        Time oldDuration = this.duration;
        this.duration = Duration.DURATION_UNKNOWN;
        for (i = 0; i < this.internalNodeList.size(); ++i) {
            c = (Controller)this.internalNodeList.elementAt(i);
            dur = c.getDuration();
            if (dur.equals(Duration.DURATION_UNBOUNDED)) {
                this.duration = dur;
                break;
            }
            if (dur.getSeconds() <= 0.0 || dur.equals(Duration.DURATION_UNKNOWN) || !this.duration.equals(Duration.DURATION_UNKNOWN) && this.duration.getNanoseconds() >= dur.getNanoseconds()) continue;
            this.duration = dur;
        }
        if (!this.duration.equals(Duration.DURATION_UNKNOWN) && !this.duration.equals(Duration.DURATION_UNBOUNDED)) {
            for (i = 0; i < this.nodeList.size(); ++i) {
                c = (Controller)this.nodeList.elementAt(i);
                if (this.internalNodeList.contains(c)) continue;
                dur = c.getDuration();
                if (dur.getSeconds() <= 0.0) {
                    dur = Duration.DURATION_UNKNOWN;
                }
                if (dur.equals(Duration.DURATION_UNKNOWN) || dur.equals(Duration.DURATION_UNBOUNDED)) {
                    this.duration = dur;
                    break;
                }
                if (this.duration.getNanoseconds() >= dur.getNanoseconds()) continue;
                this.duration = dur;
            }
        }
        if (this.duration.getNanoseconds() != oldDuration.getNanoseconds()) {
            this.setMediaLength(this.duration.getNanoseconds());
            this.sendEvent(new DurationUpdateEvent(this, this.duration));
        }
    }

    public void setStopTime(Time t) {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot set stop time on an unrealized controller.");
        }
        Vector list = this.getNodeList();
        int i = list.size();
        while (--i >= 0) {
            Controller c = (Controller)this.getNodeList().elementAt(i);
            if (this.internalNodeList.contains(c)) continue;
            c.setStopTime(t);
        }
        super.setStopTime(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMediaTime(Time now) {
        Integer n = this.mediaTimeSync;
        synchronized (n) {
            boolean restart = false;
            if (this.getState() == 600) {
                restart = true;
                this.stop("restarting");
            }
            super.setMediaTime(now);
            int i = this.getNodeList().size();
            while (--i >= 0) {
                ((Controller)this.getNodeList().elementAt(i)).setMediaTime(now);
            }
            this.doSetMediaTime(now);
            this.flush();
            if (restart) {
                this.syncStart(this.getTimeBase().getTime());
            }
        }
    }

    protected void doSetMediaTime(Time now) {
    }

    public void setVisualComponent(Component component, Rectangle bounds) {
        int state = this.getState();
        if (state != 100 && state != 200) {
            throw new NotRealizedError("Cannot set visual component on an realized player");
        }
    }

    public Component getVisualComponent() {
        int state = this.getState();
        if (state == 100 || state == 200) {
            throw new NotRealizedError("Cannot get visual component on an unrealized player");
        }
        return null;
    }

    public Component getControlPanelComponent() {
        int state = this.getState();
        if (state == 100 || state == 200) {
            throw new NotRealizedError("Cannot get control panel component on an unrealized player");
        }
        return null;
    }

    public GainControl getGainControl() {
        int state = this.getState();
        if (state == 100 || state == 200) {
            throw new NotRealizedError("Cannot get gain control on an unrealized player");
        }
        return this.gainControl;
    }

    public void gainChange(GainChangeEvent gce) {
        System.out.println("MediaPlayer.gainChange: " + gce.getLevel());
    }

    public void muteChange(boolean m) {
        System.out.println("MediaPlayer.muteChange(): " + m);
    }

    public void addControls(Control[] newControls) {
        if (this.controls == null) {
            this.controls = newControls;
        } else {
            int i;
            Control[] concat = new Control[this.controls.length + newControls.length];
            for (i = 0; i < this.controls.length; ++i) {
                concat[i] = this.controls[i];
            }
            for (i = 0; i < newControls.length; ++i) {
                concat[i + this.controls.length] = newControls[i];
            }
            this.controls = concat;
        }
    }

    public Control[] getControls() {
        return this.controls;
    }

    public final Vector getNodeList() {
        return this.nodeList;
    }

    private Vector getPotentialEventsList() {
        return this.potentialEventsList;
    }

    private void resetReceivedEventList() {
        if (this.receivedEventList != null) {
            this.receivedEventList.removeAllElements();
        }
    }

    private Vector getReceivedEventsList() {
        return this.receivedEventList;
    }

    private void updateReceivedEventsList(ControllerEvent event) {
        if (this.receivedEventList != null) {
            Controller source = event.getSourceController();
            if (this.receivedEventList.contains(source)) {
                return;
            }
            this.receivedEventList.addElement(source);
        }
    }

    public final void start() {
        if (this.restartFrom != null) {
            return;
        }
        if (this.getState() == 600) {
            this.sendEvent(new StartEvent(this, 600, 600, 600, this.mediaTimeAtStart, this.startTime));
            return;
        }
        if (this.playThread == null || !this.playThread.isAlive()) {
            this.setTargetState(600);
            try {
                JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadArgs);
                JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadGroupArgs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.playThread = new PlayThread(this);
            this.playThread.start();
        }
    }

    public final void syncStart(Time tbt) {
        int state = this.getState();
        if (state == 600) {
            throw new ClockStartedError("syncStart() cannot be used on an already started player");
        }
        if (state != 500) {
            throw new NotPrefetchedError("Cannot start player before it has been prefetched");
        }
        this.setTargetState(600);
        int size = this.getNodeList().size();
        for (int i = 0; i < size; ++i) {
            if (this.getTargetState() != 600) continue;
            ((Controller)this.getNodeList().elementAt(i)).syncStart(tbt);
        }
        if (this.getTargetState() == 600) {
            this.startTime = tbt;
            this.mediaTimeAtStart = this.getMediaTime();
            super.syncStart(tbt);
        }
    }

    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean synchronousRealize() {
        if (this.getState() != 100) {
            return false;
        }
        this.addControllerListener(this);
        this.realize();
        if (this.getState() != 200) {
            this.removeControllerListener(this);
            return false;
        }
        this.realizeCompletionEvent = null;
        this.waitingForRealizeCompleteEvent = true;
        try {
            while (this.realizeCompletionEvent == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.waitingForRealizeCompleteEvent = false;
            this.removeControllerListener(this);
        }
        return this.realizeCompletionEvent instanceof RealizeCompleteEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean synchronousPrefetch() {
        boolean realized;
        boolean bl = realized = this.getState() == 300;
        if (this.getState() == 100) {
            realized = this.synchronousRealize();
        }
        if (this.getState() != 300) {
            return false;
        }
        this.addControllerListener(this);
        this.prefetch();
        if (this.getState() != 400) {
            this.removeControllerListener(this);
            return false;
        }
        this.prefetchCompletionEvent = null;
        this.waitingForPrefetchCompleteEvent = true;
        try {
            while (this.prefetchCompletionEvent == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.waitingForPrefetchCompleteEvent = false;
            this.removeControllerListener(this);
        }
        return this.prefetchCompletionEvent instanceof PrefetchCompleteEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void play() {
        if (this.getTargetState() != 600) {
            return;
        }
        int state = this.getState();
        if (state == 100 || state == 300) {
            this.prefetch();
        }
        while (this.getState() == 200 || this.getState() == 400) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Integer n = this.mediaTimeSync;
        synchronized (n) {
            if (this.getTargetState() == 600 && this.getState() == 500) {
                this.syncStart(this.getTimeBase().getTime());
            }
        }
    }

    protected void doStop() {
    }

    public final void stop() {
        this.stop("StopByRequest");
    }

    protected void stopAtTime() {
        this.stop("StopAtTime");
        this.setStopTime(Clock.RESET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(String request) {
        int state = this.getState();
        switch (state) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(state);
                break;
            }
            case 200: {
                this.setTargetState(300);
                break;
            }
            case 400: 
            case 600: {
                this.setTargetState(500);
            }
        }
        if (this.getState() != 600 && request.equals("StopByRequest")) {
            this.sendEvent(new StopByRequestEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
        } else if (this.getState() == 600) {
            MediaPlayer mediaPlayer = this;
            synchronized (mediaPlayer) {
                this.potentialEventsList = this.stopEventList;
                this.resetReceivedEventList();
                this.receivedAllEvents = false;
                this.currentNodeList.removeAllElements();
                if (this.nodeList == null) {
                    return;
                }
                int i = this.nodeList.size();
                while (--i >= 0) {
                    Controller c = (Controller)this.nodeList.elementAt(i);
                    this.currentNodeList.addElement(c);
                    c.stop();
                }
                if (this.currentNodeList == null) {
                    return;
                }
                if (!this.currentNodeList.isEmpty()) {
                    try {
                        while (!this.receivedAllEvents) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.currentNodeList.removeAllElements();
                }
                this.eomEventsReceivedFrom.removeAllElements();
                super.stop();
                if (request.equals("StopByRequest")) {
                    this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                } else if (request.equals("StopAtTime")) {
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                } else if (request.equals("restarting")) {
                    this.setTargetState(600);
                    this.sendEvent(new RestartingEvent(this, 600, 400, this.getTargetState(), this.getMediaTime()));
                }
            }
        }
    }

    protected final void addNode(Controller node) {
        if (node != null && !this.nodeList.contains(node)) {
            this.nodeList.addElement(node);
            if (node instanceof MediaController) {
                ((MediaController)node).setParent(this);
            }
        }
        this.updateDuration();
    }

    protected final void addNode(Controller node, boolean optional) {
        if (node != null && !this.nodeList.contains(node)) {
            this.nodeList.addElement(node);
            if (node instanceof MediaController) {
                ((MediaController)node).setParent(this);
            }
            if (optional) {
                this.optionalNodeList.addElement(node);
            }
        }
        this.updateDuration();
    }

    protected final void removeNode(Controller node) {
        if (node != null && this.nodeList.contains(node)) {
            this.nodeList.removeElement(node);
        }
    }

    public final synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        int playerState = this.getState();
        if (playerState == 600) {
            throw new ClockStartedError("Cannot add controller to a started player");
        }
        if (playerState == 100 || playerState == 200) {
            throw new NotRealizedError("A Controller cannot be added to an Unrealized Player");
        }
        if (newController == null) {
            return;
        }
        int controllerState = newController.getState();
        if (controllerState == 100 || controllerState == 200) {
            throw new NotRealizedError("An Unrealized Controller cannot be added to a Player");
        }
        if (this.nodeList.contains(newController)) {
            return;
        }
        if (playerState == 500 && (controllerState == 300 || controllerState == 400)) {
            this.deallocate();
        }
        newController.setTimeBase(this.getTimeBase());
        newController.setMediaTime(this.getMediaTime());
        newController.setStopTime(this.getStopTime());
        float rate = this.getRate();
        if (newController.setRate(rate) != rate) {
            newController.setRate(1.0f);
            this.setRate(1.0f);
        }
        this.nodeList.addElement(newController);
        if (newController instanceof MediaController) {
            ((MediaController)newController).setParent(this);
        }
        newController.addControllerListener(this);
        this.updateDuration();
    }

    public final synchronized void removeController(Controller oldController) {
        int state = this.getState();
        if (state == 600) {
            throw new ClockStartedError("Cannot remove controller from a started player");
        }
        if (state == 100 || state == 200) {
            throw new NotRealizedError("Cannot remove controller from a unrealized player");
        }
        if (oldController == null) {
            return;
        }
        if (this.nodeList.contains(oldController)) {
            this.nodeList.removeElement(oldController);
            oldController.removeControllerListener(this);
            this.updateDuration();
            try {
                oldController.setTimeBase(null);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
                // empty catch block
            }
        }
    }

    protected abstract boolean createNodes();

    protected abstract boolean connectNodes();

    protected abstract boolean audioEnabled();

    protected abstract boolean videoEnabled();

    protected abstract TimeBase getMasterTimeBase();

    protected synchronized boolean doRealize() {
        Controller c;
        int i;
        if (this.createNodes()) {
            this.internalNodeList = (Vector)this.getNodeList().clone();
            i = this.getNodeList().size();
            while (--i >= 0) {
                ((Controller)this.getNodeList().elementAt(i)).addControllerListener(this);
            }
        } else {
            return false;
        }
        this.potentialEventsList = this.realizeEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentNodeList.removeAllElements();
        i = this.getNodeList().size();
        while (--i >= 0) {
            c = (Controller)this.getNodeList().elementAt(i);
            if (c.getState() != 100) continue;
            this.currentNodeList.addElement(c);
        }
        i = this.currentNodeList.size();
        while (--i >= 0) {
            c = (Controller)this.currentNodeList.elementAt(i);
            c.realize();
        }
        if (!this.currentNodeList.isEmpty()) {
            try {
                while (!this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.currentNodeList.removeAllElements();
        }
        i = this.getNodeList().size();
        while (--i >= 0) {
            c = (Controller)this.getNodeList().elementAt(i);
            if (c.getState() == 300) continue;
            System.err.println("Error: Unable to realize " + c);
            return false;
        }
        this.createGainControl();
        this.updateDuration();
        return this.connectNodes();
    }

    protected void createGainControl() {
        if (this.audioEnabled()) {
            this.gainControl = new GainCA(false);
            this.gainControl.addGainChangeListener(this);
        }
    }

    protected synchronized void completeRealize() {
        super.completeRealize();
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException e) {
            System.out.println(e);
        }
        this.notify();
    }

    protected synchronized void doFailedRealize() {
        super.doFailedRealize();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completePrefetch() {
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException e) {
            System.out.println(e);
        }
        super.completePrefetch();
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.notify();
        }
    }

    protected synchronized void doFailedPrefetch() {
        super.doFailedPrefetch();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void abortRealize() {
        if (this.nodeList != null) {
            int i = this.nodeList.size();
            while (--i >= 0) {
                Controller c = (Controller)this.nodeList.elementAt(i);
                c.deallocate();
            }
        }
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.notify();
        }
    }

    protected void allocBuffers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPrefetch() {
        Controller c;
        if (this.deallocated) {
            this.setMediaTime(new Time(0L));
            this.deallocated = false;
        }
        this.allocBuffers();
        this.potentialEventsList = this.prefetchEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentNodeList.removeAllElements();
        Vector list = this.getNodeList();
        if (list == null) {
            return false;
        }
        int i = list.size();
        while (--i >= 0) {
            c = (Controller)list.elementAt(i);
            if (c.getState() != 300) continue;
            this.currentNodeList.addElement(c);
            c.prefetch();
        }
        if (!this.currentNodeList.isEmpty()) {
            c = this;
            synchronized (c) {
                try {
                    while (!this.receivedAllEvents) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.currentNodeList.removeAllElements();
            }
        }
        i = list.size();
        while (--i >= 0) {
            c = (Controller)list.elementAt(i);
            if (c.getState() == 500) continue;
            System.err.println("Error: Unable to prefetch " + c);
            if (this.optionalNodeList.contains(c)) {
                this.removedNodeList.addElement(c);
                continue;
            }
            return false;
        }
        if (this.removedNodeList != null) {
            i = this.removedNodeList.size();
            while (--i >= 0) {
                Object o = this.removedNodeList.elementAt(i);
                this.nodeList.removeElement(o);
                ((MediaController)o).close();
                if (this.deviceBusy((MediaController)o)) continue;
                return false;
            }
            this.removedNodeList.removeAllElements();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void abortPrefetch() {
        this.flush();
        if (this.nodeList != null) {
            int i = this.nodeList.size();
            while (--i >= 0) {
                Controller c = (Controller)this.nodeList.elementAt(i);
                c.deallocate();
            }
        }
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.notify();
        }
        this.deallocated = true;
    }

    protected void flush() {
        if (this.getState() == 600) {
            throw new ClockStartedError("flush() cannot be used on an already started player");
        }
    }

    protected boolean deviceBusy(MediaController mc) {
        return true;
    }

    protected void slaveToMasterTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.setTimeBase(tb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfAllEventsArrived(Vector nodeList, Vector receivedEventList) {
        if (receivedEventList != null && receivedEventList.size() == this.currentNodeList.size()) {
            this.receivedAllEvents = true;
            this.resetReceivedEventList();
            MediaPlayer mediaPlayer = this;
            synchronized (mediaPlayer) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvent(ControllerEvent evt) {
        Controller source = evt.getSourceController();
        if (source == this) {
            if (this.waitingForRealizeCompleteEvent && this.realizeEventList.contains(evt.getClass().getName())) {
                this.realizeCompletionEvent = evt;
                MediaPlayer mediaPlayer = this;
                synchronized (mediaPlayer) {
                    this.notifyAll();
                }
            }
            if (this.waitingForPrefetchCompleteEvent && this.prefetchEventList.contains(evt.getClass().getName())) {
                this.prefetchCompletionEvent = evt;
                MediaPlayer mediaPlayer = this;
                synchronized (mediaPlayer) {
                    this.notifyAll();
                }
            }
            return;
        }
        if (evt instanceof ControllerErrorEvent && this.nodeList.contains(source) && !(evt instanceof ResourceUnavailableEvent)) {
            this.sendEvent(new ControllerErrorEvent(this, ((ControllerErrorEvent)evt).getMessage()));
            this.close();
        }
        if (evt instanceof DurationUpdateEvent && this.nodeList.contains(source)) {
            this.updateDuration();
            return;
        }
        if (evt instanceof RestartingEvent && this.nodeList.contains(source)) {
            this.restartFrom = source;
            int i = this.getNodeList().size();
            super.stop();
            this.setTargetState(500);
            for (int ii = 0; ii < i; ++ii) {
                Controller c = (Controller)this.getNodeList().elementAt(ii);
                if (c == source) continue;
                c.stop();
            }
            super.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        }
        if (evt instanceof StartEvent && source == this.restartFrom) {
            this.restartFrom = null;
            this.start();
        }
        if (evt instanceof EndOfMediaEvent && this.nodeList.contains(source)) {
            if (this.eomEventsReceivedFrom.contains(source)) {
                return;
            }
            this.eomEventsReceivedFrom.addElement(source);
            if (this.eomEventsReceivedFrom.size() == this.nodeList.size()) {
                this.eomEventsReceivedFrom.removeAllElements();
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
            }
            return;
        }
        Vector nodeList = this.getNodeList();
        Vector eventList = this.getPotentialEventsList();
        if (nodeList != null && nodeList.contains(source) && eventList != null && eventList.contains(evt.getClass().getName())) {
            this.updateReceivedEventsList(evt);
            this.notifyIfAllEventsArrived(nodeList, this.getReceivedEventsList());
        }
    }

    private boolean trySetRate(float rate) {
        Vector nodeList = this.getNodeList();
        int i = nodeList.size();
        while (--i >= 0) {
            Controller c = (Controller)nodeList.elementAt(i);
            if (c.setRate(rate) == rate) continue;
            return false;
        }
        return true;
    }

    protected float doSetRate(float factor) {
        return factor;
    }

    public float setRate(float rate) {
        float rateSet;
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot set rate on an unrealized Player.");
        }
        if (this.source instanceof RateConfigureable) {
            rate = this.checkRateConfig((RateConfigureable)((Object)this.source), rate);
        }
        float oldRate = this.getRate();
        boolean restart = false;
        if (this.getState() == 600) {
            restart = true;
            this.stop("restarting");
        }
        if (!this.trySetRate(rate)) {
            if (!this.trySetRate(oldRate)) {
                this.trySetRate(1.0f);
                rateSet = 1.0f;
            } else {
                rateSet = oldRate;
            }
        } else {
            rateSet = rate;
        }
        super.setRate(rateSet);
        if (oldRate != rateSet && rateSet == 1.0f) {
            this.setMediaTime(this.getMediaTime());
        }
        if (restart) {
            this.syncStart(this.getTimeBase().getTime());
        }
        return rateSet;
    }

    float checkRateConfig(RateConfigureable rc, float rate) {
        RateConfiguration[] config = rc.getRateConfigurations();
        if (config == null) {
            return 1.0f;
        }
        float corrected = 1.0f;
        for (int i = 0; i < config.length; ++i) {
            RateRange rr = config[i].getRate();
            if (rr == null || !(rr.getMinimumRate() <= rate) || !(rr.getMaximumRate() >= rate)) continue;
            rr.setCurrentRate(rate);
            corrected = rate;
            RateConfiguration c = rc.setRateConfiguration(config[i]);
            if (c == null || (rr = c.getRate()) == null) break;
            corrected = rr.getCurrentRate();
            break;
        }
        return corrected;
    }

    static {
        try {
            new JMFProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        systemTimeBase = new SystemTimeBase();
        defaultColorModel = null;
    }

    class GainCA
    extends GainControlAdapter {
        public GainCA(boolean mute) {
            super(mute);
        }

        public void setMute(boolean m) {
            MediaPlayer.this.muteChange(m);
            super.setMute(m);
        }
    }

    class PlayThread
    extends MediaThread {
        MediaPlayer player;

        public PlayThread(MediaPlayer player) {
            this.player = player;
            this.setName(this.getName() + " (PlayThread)");
            this.useControlPriority();
        }

        public void run() {
            this.player.play();
        }
    }
}

