/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv.media;

import com.sun.tv.media.MediaClock;
import com.sun.tv.media.PrefetchWorkThread;
import com.sun.tv.media.RealizeWorkThread;
import com.sun.tv.media.RecvEventQueue;
import com.sun.tv.media.SendEventQueue;
import com.sun.tv.media.StopTimeThread;
import com.sun.tv.media.TimedStartThread;
import com.sun.tv.media.util.JMFSecurity;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.Duration;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaTimeSetEvent;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.TransitionEvent;

public abstract class MediaController
implements Controller,
ControllerListener,
Duration,
EventListener {
    private int targetState = 100;
    protected int state = 100;
    private Vector listenerList = null;
    private SendEventQueue sendEvtQueue;
    private RecvEventQueue recvEvtQueue;
    private RealizeWorkThread realizeThread = null;
    private PrefetchWorkThread prefetchThread = null;
    private String processError = null;
    private MediaClock clock;
    private TimedStartThread startThread = null;
    private StopTimeThread stopTimeThread = null;
    protected Controller parent = null;

    public MediaController() {
        try {
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadArgs);
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadGroupArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendEvtQueue = new SendEventQueue(this);
        this.sendEvtQueue.setName(this.sendEvtQueue.getName() + ": SendEventQueue: " + this.getClass().getName());
        this.sendEvtQueue.start();
        this.recvEvtQueue = new RecvEventQueue(this);
        this.recvEvtQueue.setName(this.recvEvtQueue.getName() + ": RecvEventQueue: " + this.getClass().getName());
        this.recvEvtQueue.start();
        this.clock = new MediaClock();
    }

    protected abstract boolean doRealize();

    protected abstract void abortRealize();

    protected abstract boolean doPrefetch();

    protected abstract void abortPrefetch();

    protected abstract void doStart();

    protected void doStop() {
    }

    public void close() {
        if (this.recvEvtQueue != null) {
            this.recvEvtQueue.kill();
            this.recvEvtQueue = null;
        }
        this.doClose();
        this.sendEvent(new ControllerClosedEvent(this));
    }

    protected void doClose() {
    }

    protected final void cleanup() {
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.kill();
            this.sendEvtQueue = null;
        }
        if (this.recvEvtQueue != null) {
            this.recvEvtQueue.kill();
            this.recvEvtQueue = null;
        }
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot set time base on an unrealized controller.");
        }
        this.clock.setTimeBase(tb);
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public Control getControl(String forName) {
        return null;
    }

    public void syncStart(Time tbt) {
        if (this.state == 100 || this.state == 200 || this.state == 300 || this.state == 400) {
            throw new NotPrefetchedError("Cannot start the controller before it has been prefetched.");
        }
        this.clock.syncStart(tbt);
        this.state = 600;
        this.setTargetState(600);
        this.sendEvent(new StartEvent(this, 500, 600, 600, this.getMediaTime(), tbt));
        if (this.activateStopThread()) {
            this.stopAtTime();
            return;
        }
        try {
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadArgs);
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadGroupArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startThread = new TimedStartThread(this, tbt.getNanoseconds());
        this.startThread.setName(this.startThread.getName() + " ( startThread: " + this + " )");
        this.startThread.start();
    }

    private boolean activateStopThread() {
        long stopTime = this.getStopTime().getNanoseconds();
        if (stopTime != Long.MAX_VALUE) {
            long timeToStop = (long)((float)(stopTime - this.getMediaTime().getNanoseconds()) / this.getRate());
            if (timeToStop > 100000000L) {
                try {
                    JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadArgs);
                    JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadGroupArgs);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.stopTimeThread = new StopTimeThread(this, timeToStop);
                this.stopTimeThread.start();
                return false;
            }
            return true;
        }
        return false;
    }

    public void stop() {
        if (this.state == 600) {
            this.clock.stop();
            this.state = 500;
            this.setTargetState(500);
            if (this.stopTimeThread == null || !this.stopTimeThread.isAlive() || Thread.currentThread() != this.stopTimeThread) {
                // empty if block
            }
            if (this.startThread != null && this.startThread.isAlive()) {
                this.startThread.abort();
            }
            this.doStop();
        }
    }

    protected void stopAtTime() {
    }

    public void setStopTime(Time t) {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot set stop time on an unrealized controller.");
        }
        Time oldStopTime = this.getStopTime();
        this.clock.setStopTime(t);
        boolean stopTimeHasPassed = false;
        if (this.state == 600 && this.activateStopThread()) {
            stopTimeHasPassed = true;
        }
        if (oldStopTime.getNanoseconds() != t.getNanoseconds()) {
            this.sendEvent(new StopTimeChangeEvent(this, t));
        }
        if (stopTimeHasPassed) {
            this.stopAtTime();
        }
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public void setMediaTime(Time now) {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot set media time on a unrealized controller");
        }
        this.clock.setMediaTime(now);
        this.sendEvent(new MediaTimeSetEvent(this, this.getMediaTime()));
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    protected final Time getMediaClockTime() {
        return this.clock.getMediaTime();
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public TimeBase getTimeBase() {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot get Time Base from an unrealized controller");
        }
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    public float setRate(float factor) {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot set rate on an unrealized controller.");
        }
        float oldRate = this.getRate();
        float rateSet = this.doSetRate(factor);
        float newRate = this.clock.setRate(rateSet);
        if (newRate != oldRate) {
            this.sendEvent(new RateChangeEvent(this, newRate));
        }
        return newRate;
    }

    protected float doSetRate(float factor) {
        return factor;
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public final int getState() {
        return this.state;
    }

    protected final void setTargetState(int state) {
        this.targetState = state;
    }

    public final int getTargetState() {
        return this.targetState;
    }

    public Time getStartLatency() {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot get start latency from an unrealized controller");
        }
        return Controller.LATENCY_UNKNOWN;
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    protected void setMediaLength(long t) {
        this.clock.setMediaLength(t);
    }

    public final synchronized void realize() {
        if (this.getTargetState() <= 100) {
            this.setTargetState(300);
        }
        switch (this.state) {
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                this.sendEvent(new RealizeCompleteEvent(this, this.state, this.state, this.getTargetState()));
                break;
            }
            case 200: {
                break;
            }
            case 100: {
                this.state = 200;
                this.sendEvent(new TransitionEvent(this, 100, 200, this.getTargetState()));
                try {
                    JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadArgs);
                    JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadGroupArgs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.realizeThread = new RealizeWorkThread(this);
                this.realizeThread.setName(this.realizeThread.getName() + "[ " + this + " ]" + " ( realizeThread)");
                this.realizeThread.start();
            }
        }
    }

    protected synchronized void completeRealize() {
        this.state = 300;
        this.sendEvent(new RealizeCompleteEvent(this, 200, 300, this.getTargetState()));
        if (this.getTargetState() >= 500) {
            this.prefetch();
        }
    }

    protected void doFailedRealize() {
        this.state = 100;
        this.setTargetState(100);
        this.processError = "realize failed:" + this.processError;
        this.sendEvent(new ResourceUnavailableEvent(this, this.processError));
        this.processError = null;
    }

    public final void prefetch() {
        if (this.getTargetState() <= 300) {
            this.setTargetState(500);
        }
        switch (this.state) {
            case 500: 
            case 600: {
                this.sendEvent(new PrefetchCompleteEvent(this, this.state, this.state, this.getTargetState()));
                return;
            }
            case 200: {
                return;
            }
            case 400: {
                return;
            }
            case 100: {
                this.realize();
                return;
            }
        }
        this.state = 400;
        this.sendEvent(new TransitionEvent(this, 300, 400, this.getTargetState()));
        try {
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadArgs);
            JMFSecurity.enablePrivilege.invoke(JMFSecurity.privilegeManager, JMFSecurity.threadGroupArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.prefetchThread = new PrefetchWorkThread(this);
        this.prefetchThread.setName(this.prefetchThread.getName() + " ( prefetchThread)");
        this.prefetchThread.start();
    }

    protected void completePrefetch() {
        if (this.state == 500 || this.state == 600) {
            return;
        }
        this.state = 500;
        this.sendEvent(new PrefetchCompleteEvent(this, 400, 500, this.getTargetState()));
    }

    protected void doFailedPrefetch() {
        this.state = 300;
        this.setTargetState(300);
        this.processError = "prefetch failed:" + this.processError;
        this.sendEvent(new ResourceUnavailableEvent(this, this.processError));
        this.processError = null;
    }

    public final void deallocate() {
        int previousState = this.getState();
        if (this.state == 600) {
            throw new ClockStartedError("deallocate cannot be used on a started controller.");
        }
        if (this.state == 200 && this.realizeThread != null) {
            this.abortRealize();
            this.state = 100;
        }
        if (this.state == 400 || this.state == 500) {
            if (this.prefetchThread != null) {
                this.abortPrefetch();
            }
            this.state = 300;
        }
        this.setTargetState(this.state);
        this.doDeallocate();
        this.sendEvent(new DeallocateEvent(this, previousState, this.state, this.state, this.getMediaTime()));
    }

    protected void doDeallocate() {
    }

    public final synchronized void addControllerListener(ControllerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new Vector();
        }
        if (!this.listenerList.contains(listener)) {
            this.listenerList.addElement(listener);
        }
    }

    public final synchronized void removeControllerListener(ControllerListener listener) {
        if (this.listenerList != null) {
            this.listenerList.removeElement(listener);
        }
    }

    protected final void sendEvent(ControllerEvent evt) {
        if (this.sendEvtQueue != null) {
            this.sendEvtQueue.postEvent(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatchEvent(ControllerEvent evt) {
        if (evt instanceof ControllerErrorEvent) {
            if (!(evt instanceof ResourceUnavailableEvent)) {
                this.cleanup();
                this.doClose();
            }
        } else if (evt instanceof ControllerClosedEvent) {
            this.cleanup();
        }
        if (this.listenerList == null) {
            return;
        }
        Vector vector = this.listenerList;
        synchronized (vector) {
            Enumeration list = this.listenerList.elements();
            while (list.hasMoreElements()) {
                ControllerListener listener = (ControllerListener)list.nextElement();
                listener.controllerUpdate(evt);
            }
        }
    }

    public final void controllerUpdate(ControllerEvent evt) {
        if (this.recvEvtQueue != null) {
            this.recvEvtQueue.postEvent(evt);
        }
    }

    protected void processEvent(ControllerEvent evt) {
    }

    final void setParent(Controller parent) {
        this.parent = parent;
    }

    final Controller getParent() {
        return this.parent;
    }
}

