/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import com.sun.tv.AppSignalEvent;
import com.sun.tv.AppSignalEventListener;
import com.sun.tv.Holder;
import com.sun.tv.Request;
import com.sun.tv.Result;
import com.sun.tv.XletContextImpl;
import com.sun.tv.XletLoader;
import com.sun.tv.XletProxy;
import com.sun.tv.XletRunnable;
import com.sun.tv.XletState;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.tv.xlet.Xlet;
import javax.tv.xlet.XletContext;

public class XletManager
implements AppSignalEventListener {
    private static XletManager xletManager = null;
    private static Hashtable stateTable = new Hashtable();
    private static Hashtable proxyTable = new Hashtable();
    private static Hashtable idTable = new Hashtable();
    private static Hashtable signalTable = new Hashtable();
    private boolean xletArrived = false;

    public static XletManager createInstance() {
        if (xletManager == null) {
            xletManager = new XletManager();
        }
        return xletManager;
    }

    public Xlet signalReceived(AppSignalEvent sigEvent) {
        Xlet xlet = null;
        switch (sigEvent.getControlCode()) {
            case 1: {
                xlet = this.prepareXlet(sigEvent);
                if (xlet == null) break;
                this.startXlet(xlet, ((XletProxy)proxyTable.get(xlet)).getXletContext());
                break;
            }
            case 2: {
                signalTable.put(sigEvent.getApplicationIdentifier(), sigEvent);
                break;
            }
            case 3: {
                sigEvent = (AppSignalEvent)signalTable.get(sigEvent.getApplicationIdentifier());
                xlet = this.prepareXlet(sigEvent);
                if (xlet == null) break;
                this.startXlet(xlet, ((XletProxy)proxyTable.get(xlet)).getXletContext());
                break;
            }
            case 4: {
                xlet = this.prepareXlet(sigEvent);
                break;
            }
            case 6: {
                xlet = (Xlet)idTable.get(sigEvent.getApplicationIdentifier());
                this.pauseXlet(xlet);
                break;
            }
            case 7: {
                xlet = (Xlet)idTable.get(sigEvent.getApplicationIdentifier());
                this.destroyXlet(xlet, false);
                this.cleanupXlet(xlet);
                break;
            }
            case 8: {
                xlet = (Xlet)idTable.get(sigEvent.getApplicationIdentifier());
                this.destroyXlet(xlet, true);
                this.cleanupXlet(xlet);
            }
        }
        return xlet;
    }

    private Xlet prepareXlet(AppSignalEvent sigEvent) {
        if (sigEvent == null) {
            return null;
        }
        try {
            XletLoader xletLoader = new XletLoader("", "." + File.separator + "xlets" + File.separator);
            Class xletClass = xletLoader.loadClass(sigEvent.getClassName().trim());
            Object obj = xletClass.newInstance();
            if (!(obj instanceof Xlet)) {
                return null;
            }
            Xlet myXletIns = (Xlet)obj;
            XletContextImpl ctx = new XletContextImpl(this, myXletIns, sigEvent.getServiceContext(), sigEvent.getArgs());
            ThreadGroup tg = new ThreadGroup("xlet name from signal");
            Holder reqHolder = new Holder();
            Holder resultHolder = new Holder();
            XletRunnable xletRun = new XletRunnable(reqHolder, resultHolder);
            Thread xletActionThread = new Thread(tg, xletRun);
            xletActionThread.start();
            XletProxy xletProxy = new XletProxy(xletLoader, this, ctx, tg, xletRun, reqHolder, resultHolder, myXletIns);
            proxyTable.put(myXletIns, xletProxy);
            idTable.put(sigEvent.getApplicationIdentifier(), myXletIns);
            XletState myXletState = new XletState();
            myXletState.setState(0);
            stateTable.put(myXletIns, myXletState);
            return myXletIns;
        }
        catch (Exception ex) {
            System.out.println("XletException: " + ex);
            return null;
        }
    }

    private Result XletAction(Xlet myXlet, Request req) {
        XletProxy myProxy = (XletProxy)proxyTable.get(myXlet);
        if (myProxy == null) {
            return null;
        }
        Holder reqHolder = myProxy.getReqHolder();
        Holder resultHolder = myProxy.getResultHolder();
        reqHolder.put(req);
        return null;
    }

    private void startXlet(Xlet myXlet, XletContext myXletContext) {
        if (myXlet == null) {
            return;
        }
        Request req = new Request(myXlet, myXletContext);
        Result result = this.XletAction(myXlet, req);
        this.changeXletState(myXlet, 1);
        req = new Request(myXlet, 3);
        result = this.XletAction(myXlet, req);
        this.changeXletState(myXlet, 2);
    }

    private void pauseXlet(Xlet myXlet) {
        if (myXlet == null) {
            return;
        }
        Request req = new Request(myXlet, 4);
        Result result = this.XletAction(myXlet, req);
        this.changeXletState(myXlet, 1);
    }

    private void destroyXlet(Xlet myXlet, boolean unconditional) {
        if (myXlet == null) {
            return;
        }
        Request req = new Request(myXlet, unconditional);
        Result result = this.XletAction(myXlet, req);
        this.changeXletState(myXlet, 3);
    }

    public void cleanupXlet(Xlet myXlet) {
        if (myXlet == null) {
            return;
        }
        XletProxy myProxy = (XletProxy)proxyTable.get(myXlet);
        if (myProxy != null) {
            myProxy.getActionThread().shouldRun = false;
        }
        if (idTable.contains(myXlet)) {
            Enumeration enumeration = idTable.keys();
            while (enumeration.hasMoreElements()) {
                String oldXletID = (String)enumeration.nextElement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeXletState(Xlet xlet, int newState) {
        Xlet xlet2 = xlet;
        synchronized (xlet2) {
            if (stateTable.containsKey(xlet)) {
                XletState oldXletState = (XletState)stateTable.get(xlet);
                int oldState = oldXletState.getState();
                if (oldState == 3) {
                    return;
                }
                oldXletState.setState(newState);
            }
        }
    }

    public XletState getXletState(Xlet xlet) {
        return (XletState)stateTable.get(xlet);
    }
}

