/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class XletLoader
extends ClassLoader {
    private String myCarousel = null;
    private String baseDir = null;

    protected XletLoader(String carousel, String baseDir) throws SecurityException {
        this.myCarousel = carousel;
        this.baseDir = baseDir;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public Class loadClass(String className, boolean link) throws ClassNotFoundException {
        try {
            Class<?> newClass = this.findLoadedClass(className);
            if (newClass == null) {
                try {
                    newClass = this.findSystemClass(className);
                    if (newClass != null) {
                        return newClass;
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                String fileName = className.replace('.', File.separatorChar) + ".class";
                if (this.baseDir != null) {
                    fileName = this.baseDir + fileName;
                }
                if (this.myCarousel != null) {
                    fileName = this.myCarousel + fileName;
                }
                FileInputStream classStream = new FileInputStream(fileName);
                byte[] classBytes = new byte[classStream.available()];
                classStream.read(classBytes);
                newClass = this.defineClass(className, classBytes, 0, classBytes.length);
            }
            if (link && newClass != null) {
                this.resolveClass(newClass);
            }
            return newClass;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className);
        }
    }
}

