/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import com.sun.tv.AppSignalEvent;
import com.sun.tv.CacheManager;
import com.sun.tv.DisplayManager;
import com.sun.tv.Handler;
import com.sun.tv.LocatorImpl;
import com.sun.tv.NotifyServiceContextThread;
import com.sun.tv.XletManager;
import com.sun.tv.si.ServiceComponentImpl;
import com.sun.tv.si.ServiceImpl;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.CachingControlEvent;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.StartEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.tv.locator.InvalidLocatorException;
import javax.tv.locator.Locator;
import javax.tv.locator.LocatorFactory;
import javax.tv.service.SIElement;
import javax.tv.service.SIManager;
import javax.tv.service.Service;
import javax.tv.service.navigation.ServiceComponent;
import javax.tv.service.navigation.StreamType;
import javax.tv.service.selection.AlternativeContentEvent;
import javax.tv.service.selection.InvalidServiceComponentException;
import javax.tv.service.selection.NormalContentEvent;
import javax.tv.service.selection.PresentationTerminatedEvent;
import javax.tv.service.selection.SelectPermission;
import javax.tv.service.selection.SelectionFailedEvent;
import javax.tv.service.selection.ServiceContentHandler;
import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextDestroyedEvent;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.service.selection.ServiceContextListener;
import javax.tv.service.selection.ServiceContextPermission;
import javax.tv.xlet.Xlet;

public class ServiceContextImpl
implements ServiceContext,
ControllerListener {
    private Locator serviceLocator = null;
    private Vector componentLocators = new Vector();
    private Hashtable serviceHandlers = new Hashtable();
    private Vector serviceListeners = new Vector();
    private static final int STATE_PRESENTING = 0;
    private static final int STATE_NOT_PRESENTING = 1;
    private static final int STATE_PRESENTATION_PENDING = 2;
    private static final int STATE_DESTROYED = 3;
    private int state = 1;
    private static final int PLAY_NORMAL = 0;
    private static final int PLAY_ALTERNATE = 1;
    private static final int PLAY_SELECTION_FAILED = 2;

    private boolean waitTillRealized(Player player) {
        int MAX_SLEEPS = 100;
        if (player.getState() == 100) {
            return false;
        }
        if (player.getState() >= 300) {
            return true;
        }
        if (player.getState() != 200) {
            return false;
        }
        for (int i = 0; i < 100; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (player.getState() < 300) continue;
            return true;
        }
        return false;
    }

    private void Play(Locator locator, boolean autoRunOnly) throws InvalidLocatorException, IllegalStateException {
        if (locator == null) {
            return;
        }
        if (!LocatorImpl.isServiceComponent(locator)) {
            return;
        }
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        ServiceComponent sc = (ServiceComponent)siCache.get(locator);
        if (sc != null) {
            if (sc.getStreamType() == StreamType.VIDEO) {
                this.PlayServiceComponent(this.getService(), locator);
            } else if (sc.getStreamType() == StreamType.AUDIO) {
                this.PlayServiceComponent(this.getService(), locator);
            } else if (sc.getStreamType() == StreamType.SUBTITLES) {
                this.PlayServiceComponent(this.getService(), locator);
            } else if (sc.getStreamType() == StreamType.DATA) {
                this.PlayServiceComponentData(locator, autoRunOnly);
            } else if (sc.getStreamType() == StreamType.SECTIONS) {
                this.PlayServiceComponent(this.getService(), locator);
            } else {
                this.PlayServiceComponent(this.getService(), locator);
            }
        }
    }

    private void PlayService(Locator selection) throws InvalidLocatorException, IllegalStateException {
        Handler player = (Handler)this.serviceHandlers.get(selection.toExternalForm());
        if (player == null) {
            player = new Handler(selection, this);
        }
        if (player == null || !player.validHandler()) {
            throw new InvalidLocatorException(selection);
        }
        this.serviceHandlers.put(selection.toExternalForm(), player);
        player.addControllerListener(this);
        player.start();
        if (!this.waitTillRealized(player)) {
            this.state = 2;
        }
    }

    private void PlayServiceComponent(Service service, Locator selection) throws InvalidLocatorException, IllegalStateException {
        Handler player;
        if (service == null) {
            service = SIManager.createInstance().getService(LocatorImpl.transformToService(selection));
        }
        if ((player = (Handler)this.serviceHandlers.get(service.getLocator().toExternalForm())) == null || !player.validHandler()) {
            throw new InvalidLocatorException(selection);
        }
        this.componentLocators.removeElement(selection);
        this.componentLocators.addElement(selection);
    }

    private void PlayServiceComponentData(Locator locator, boolean autoRunOnly) throws InvalidLocatorException, IllegalStateException {
        String name = LocatorImpl.getServiceComponentName(locator);
        if (name == null) {
            return;
        }
        DisplayManager dispManager = DisplayManager.createInstance();
        if (dispManager == null) {
            throw new NullPointerException();
        }
        XletManager xletManager = XletManager.createInstance();
        if (xletManager == null) {
            throw new NullPointerException();
        }
        AppSignalEvent ase = new AppSignalEvent(dispManager.getRootFrame(), 3, null, null, name, this, null);
        Xlet xlet = xletManager.signalReceived(ase);
    }

    private void Stop(Locator locator) {
        if (locator == null) {
            return;
        }
        if (LocatorImpl.isService(locator)) {
            this.StopService(locator);
            for (int i = 0; i < this.componentLocators.size(); ++i) {
                this.Stop((Locator)this.componentLocators.elementAt(i));
            }
        } else if (LocatorImpl.isServiceComponent(locator)) {
            CacheManager siCache = CacheManager.getSICache();
            if (siCache == null) {
                return;
            }
            ServiceComponent sc = (ServiceComponent)siCache.get(locator);
            if (sc != null) {
                if (sc.getStreamType() == StreamType.VIDEO) {
                    this.StopServiceComponent(this.getService(), locator);
                } else if (sc.getStreamType() == StreamType.AUDIO) {
                    this.StopServiceComponent(this.getService(), locator);
                } else if (sc.getStreamType() == StreamType.SUBTITLES) {
                    this.StopServiceComponent(this.getService(), locator);
                } else if (sc.getStreamType() == StreamType.DATA) {
                    this.StopServiceComponentData(locator);
                } else if (sc.getStreamType() == StreamType.SECTIONS) {
                    this.StopServiceComponent(this.getService(), locator);
                } else {
                    this.StopServiceComponent(this.getService(), locator);
                }
            }
        }
    }

    private void StopService(Locator locator) {
        Handler oldPlayer = (Handler)this.serviceHandlers.get(locator.toExternalForm());
        if (oldPlayer == null) {
            return;
        }
        DisplayManager dispManager = DisplayManager.createInstance();
        if (dispManager == null) {
            throw new NullPointerException();
        }
        Container frame = dispManager.getRootFrame();
        if (frame == null) {
            throw new NullPointerException();
        }
        if (this.waitTillRealized(oldPlayer)) {
            this.StopVisualComponent(frame, oldPlayer);
            oldPlayer.stop();
            oldPlayer.close();
            this.serviceHandlers.remove(locator.toExternalForm());
        }
    }

    private void StopServiceComponent(Service service, Locator locator) {
        try {
            Handler player;
            if (service == null) {
                service = SIManager.createInstance().getService(LocatorImpl.transformToService(locator));
            }
            if ((player = (Handler)this.serviceHandlers.get(service.getLocator().toExternalForm())) == null || !player.validHandler()) {
                throw new InvalidLocatorException(locator);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.componentLocators.removeElement(locator);
    }

    private void StopServiceComponentData(Locator locator) {
        String name = LocatorImpl.getServiceComponentName(locator);
        if (name == null) {
            return;
        }
        DisplayManager dispManager = DisplayManager.createInstance();
        if (dispManager == null) {
            throw new NullPointerException();
        }
        XletManager xletManager = XletManager.createInstance();
        if (xletManager == null) {
            throw new NullPointerException();
        }
        AppSignalEvent ase = new AppSignalEvent(dispManager.getRootFrame(), 7, null, null, name, this, null);
        xletManager.signalReceived(ase);
    }

    private void StopVisualComponent(Container frame, Player player) {
        if (player.getState() < 300) {
            return;
        }
        try {
            Component comp = player.getVisualComponent();
            if (comp != null && comp.getParent() == frame) {
                frame.remove(comp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean Contains(Locator component, Locator[] components) {
        if (components == null) {
            return false;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!LocatorImpl.equals(component, components[i])) continue;
            return true;
        }
        return false;
    }

    private void PlayComponents(Service service) throws InvalidLocatorException {
        boolean autoRunOnly = true;
        CacheManager siCache = CacheManager.getSICache();
        if (siCache == null) {
            return;
        }
        Enumeration elements = siCache.elements();
        while (elements.hasMoreElements()) {
            SIElement element = (SIElement)elements.nextElement();
            if (!(element instanceof ServiceComponentImpl)) continue;
            Locator serviceLocator = service.getLocator();
            Locator componentLocator = element.getLocator();
            String serviceName1 = LocatorImpl.getServiceName(serviceLocator);
            String serviceName2 = LocatorImpl.getServiceName(componentLocator);
            if (serviceName1 == null || serviceName2 == null || !serviceName1.equals(serviceName2)) continue;
            this.Play(componentLocator, autoRunOnly);
        }
    }

    public void select(Service selection) throws SecurityException {
        SIManager siManager;
        Locator[] locs;
        boolean autoRunOnly = false;
        if (selection == null) {
            throw new NullPointerException("service selection is null");
        }
        Locator locator = selection.getLocator();
        if (locator == null) {
            throw new NullPointerException("service locator is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.isContextOwned()) {
                sm.checkPermission(new SelectPermission(locator, "own"));
            } else {
                sm.checkPermission(new SelectPermission(locator, "*"));
            }
        }
        if (this.state == 3) {
            throw new IllegalStateException("ServiceContext has been destroyed.");
        }
        if (LocatorImpl.isTIService(locator) && (locs = LocatorImpl.transformLocator(locator)) != null && locs.length > 0) {
            locator = locs[0];
        }
        if ((siManager = SIManager.createInstance()) == null) {
            throw new NullPointerException();
        }
        ServiceImpl service = (ServiceImpl)selection;
        int reason = service.getSelectionFailedReason();
        try {
            Locator alternate;
            this.Stop(this.serviceLocator);
            this.serviceLocator = reason != 0 ? (alternate = LocatorImpl.transformToAlternate(locator)) : locator;
            this.PlayService(this.serviceLocator);
        }
        catch (Exception e) {
            this.notifyListeners(new SelectionFailedEvent(this, reason));
            this.serviceLocator = null;
        }
        try {
            this.PlayComponents(service);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void select(Locator[] components) throws InvalidLocatorException, InvalidServiceComponentException, SecurityException, IllegalStateException {
        int i;
        if (components == null) {
            throw new NullPointerException();
        }
        if (components.length == 0) {
            throw new InvalidLocatorException(null);
        }
        String serviceName = null;
        for (int i2 = 0; i2 < components.length; ++i2) {
            if (!LocatorImpl.isServiceComponent(components[i2])) {
                throw new InvalidLocatorException(components[i2]);
            }
            if (serviceName == null) {
                serviceName = LocatorImpl.getServiceName(components[i2]);
            }
            if (serviceName == null) {
                throw new InvalidServiceComponentException(components[i2]);
            }
            if (LocatorImpl.getServiceName(components[i2]).equals(serviceName)) continue;
            throw new InvalidServiceComponentException(components[i2]);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            for (i = 0; i < components.length; ++i) {
                if (this.isContextOwned()) {
                    sm.checkPermission(new SelectPermission(components[i], "own"));
                    continue;
                }
                sm.checkPermission(new SelectPermission(components[i], "*"));
            }
        }
        if (this.state == 3) {
            throw new IllegalStateException("ServiceContext has been destroyed.");
        }
        for (i = 0; i < this.componentLocators.size(); ++i) {
            Locator componentLocator = (Locator)this.componentLocators.elementAt(i);
            if (this.Contains(componentLocator, components)) continue;
            this.Stop(componentLocator);
        }
        int reason = 0;
        try {
            String oldServiceName = LocatorImpl.getServiceName(this.serviceLocator);
            if (this.serviceLocator != null && !serviceName.equals(oldServiceName)) {
                this.Stop(this.serviceLocator);
                this.serviceLocator = null;
            }
            if (this.serviceLocator == null) {
                Locator alternate;
                String locatorStr = "service:/" + serviceName;
                Locator locator = LocatorFactory.getInstance().createLocator(locatorStr);
                ServiceImpl service = (ServiceImpl)SIManager.createInstance().getService(locator);
                if (service == null) {
                    throw new NullPointerException("service == null");
                }
                reason = service.getSelectionFailedReason();
                this.serviceLocator = reason != 0 ? (alternate = LocatorImpl.transformToAlternate(locator)) : locator;
                this.PlayService(this.serviceLocator);
            }
        }
        catch (Exception e) {
            this.notifyListeners(new SelectionFailedEvent(this, reason));
            this.serviceLocator = null;
        }
        for (int i3 = 0; i3 < components.length; ++i3) {
            if (this.componentLocators.indexOf(components[i3]) != -1) continue;
            this.Play(components[i3], false);
        }
        this.notifyListeners(new NormalContentEvent(this));
    }

    public void stop() throws SecurityException, IllegalStateException {
        int reason = 5;
        this.stop0(reason);
    }

    public void stop0(int reason) throws SecurityException, IllegalStateException {
        if (this.state == 1) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.isContextOwned()) {
                sm.checkPermission(new ServiceContextPermission("stop", "own"));
            } else {
                sm.checkPermission(new ServiceContextPermission("stop", "*"));
            }
        }
        if (this.state == 3) {
            throw new IllegalStateException("ServiceContext has been destroyed.");
        }
        Enumeration list = this.serviceHandlers.elements();
        while (list.hasMoreElements()) {
            Player player = (Player)list.nextElement();
            if (player == null) continue;
            player.stop();
            player.close();
            this.serviceHandlers.remove(this.serviceLocator.toExternalForm());
            this.serviceLocator = null;
        }
        for (int i = 0; i < this.componentLocators.size(); ++i) {
            this.Stop((Locator)this.componentLocators.elementAt(i));
        }
        this.state = 1;
        this.serviceLocator = null;
        this.notifyListeners(new PresentationTerminatedEvent(this, reason));
    }

    public void destroy() throws SecurityException {
        if (this.state == 3) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServiceContextPermission("stop", "*"));
            if (this.isContextOwned()) {
                sm.checkPermission(new ServiceContextPermission("destroy", "own"));
            } else {
                sm.checkPermission(new ServiceContextPermission("destroy", "*"));
            }
        }
        if (this.state == 0 || this.state == 2) {
            this.stop();
        }
        this.state = 3;
        this.notifyListeners(new ServiceContextDestroyedEvent(this));
        this.serviceHandlers = new Hashtable();
        this.serviceListeners = new Vector();
        this.componentLocators = new Vector();
        this.serviceLocator = null;
    }

    public ServiceContentHandler[] getServiceContentHandlers() throws SecurityException {
        if (this.state == 3) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (this.isContextOwned()) {
                sm.checkPermission(new ServiceContextPermission("getServiceContentHandlers", "own"));
            } else {
                sm.checkPermission(new ServiceContextPermission("getServiceContentHandlers", "*"));
            }
        }
        if (this.state != 0) {
            return new ServiceContentHandler[0];
        }
        int count = this.serviceHandlers.size();
        ServiceContentHandler[] handlers = new ServiceContentHandler[count];
        if (handlers == null) {
            return null;
        }
        int index = 0;
        Enumeration list = this.serviceHandlers.elements();
        while (list.hasMoreElements()) {
            handlers[index] = (ServiceContentHandler)list.nextElement();
            ++index;
        }
        return handlers;
    }

    public Locator getServiceLocator() {
        if (this.state == 1 || this.state == 3) {
            return null;
        }
        return this.serviceLocator;
    }

    public Service getService() {
        SIManager siManager = SIManager.createInstance();
        if (siManager == null) {
            throw new NullPointerException();
        }
        if (this.state == 3) {
            throw new IllegalStateException("ServiceContext has been destroyed");
        }
        try {
            return siManager.getService(this.serviceLocator);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addListener(ServiceContextListener listener) throws IllegalStateException {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.state == 3) {
            throw new IllegalStateException("ServiceContext has been destroyed.");
        }
        if (!this.serviceListeners.contains(listener)) {
            this.serviceListeners.addElement(listener);
        }
    }

    public void removeListener(ServiceContextListener listener) throws IllegalStateException {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.state == 3) {
            throw new IllegalStateException("ServiceContext has been destroyed.");
        }
        if (this.serviceListeners.contains(listener)) {
            this.serviceListeners.removeElement(listener);
        }
    }

    private void notifyListeners(ServiceContextEvent event) {
        Vector listeners = (Vector)this.serviceListeners.clone();
        for (int i = 0; i < listeners.size(); ++i) {
            ServiceContextListener listener = (ServiceContextListener)listeners.elementAt(i);
            if (listener == null) continue;
            this.notifyAsyncListener(event, listener);
        }
    }

    private void notifyAsyncListener(ServiceContextEvent event, ServiceContextListener listener) {
        if (listener == null || event == null) {
            return;
        }
        NotifyServiceContextThread thread = new NotifyServiceContextThread(event, listener);
        if (thread != null) {
            thread.start();
        }
    }

    public boolean isContextOwned() {
        try {
            ServiceContextFactory factory = ServiceContextFactory.getInstance();
            if (factory == null) {
                return false;
            }
            ServiceContext[] list = factory.getServiceContexts();
            if (list == null) {
                return false;
            }
            for (int i = 0; i < list.length; ++i) {
                if (list[i] != this) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Locator[] getServiceComponentLocators() {
        if (this.state == 3) {
            return null;
        }
        if (this.componentLocators == null) {
            return new Locator[0];
        }
        Locator[] locators = new Locator[this.componentLocators.size()];
        for (int i = 0; i < this.componentLocators.size(); ++i) {
            locators[i] = (Locator)this.componentLocators.elementAt(i);
        }
        return locators;
    }

    public boolean isDestroyed() {
        return this.state == 3;
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
        if (ce == null) {
            return;
        }
        Controller controller = ce.getSourceController();
        if (controller == null || !(controller instanceof Player)) {
            return;
        }
        Player player = (Player)controller;
        if (ce instanceof RealizeCompleteEvent) {
            DisplayManager dispManager = DisplayManager.createInstance();
            if (dispManager == null) {
                return;
            }
            Container frame = dispManager.getRootFrame();
            if (frame == null) {
                return;
            }
            Component comp = player.getVisualComponent();
            if (comp != null && comp.getParent() == null) {
                frame.add(comp);
            }
            comp = player.getControlPanelComponent();
            frame.validate();
            if (LocatorImpl.isAlternate(this.serviceLocator)) {
                this.notifyListeners(new AlternativeContentEvent(this));
            } else {
                this.notifyListeners(new NormalContentEvent(this));
            }
            this.state = 0;
        } else if (!(ce instanceof PrefetchCompleteEvent)) {
            if (ce instanceof EndOfMediaEvent) {
                player.setMediaTime(new Time(0L));
                player.start();
            } else if (ce instanceof ControllerErrorEvent) {
                System.err.println("ControllerErrorEvent: " + ce);
            } else if (!(ce instanceof ControllerClosedEvent)) {
                if (ce instanceof DurationUpdateEvent) {
                    Time t = ((DurationUpdateEvent)ce).getDuration();
                } else if (!(ce instanceof CachingControlEvent || ce instanceof StartEvent || ce instanceof MediaTimeSetEvent || ce instanceof TransitionEvent || ce instanceof RateChangeEvent || ce instanceof StopTimeChangeEvent || !(ce instanceof DurationUpdateEvent))) {
                    System.out.println("Duration: " + ((DurationUpdateEvent)ce).getDuration().getSeconds());
                }
            }
        }
    }
}

