/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import com.sun.tv.ServiceContextImpl;
import com.sun.tv.receiver.Settings;
import java.util.Vector;
import javax.tv.service.selection.InsufficientResourcesException;
import javax.tv.service.selection.ServiceContext;
import javax.tv.service.selection.ServiceContextDestroyedEvent;
import javax.tv.service.selection.ServiceContextEvent;
import javax.tv.service.selection.ServiceContextException;
import javax.tv.service.selection.ServiceContextFactory;
import javax.tv.service.selection.ServiceContextListener;
import javax.tv.service.selection.ServiceContextPermission;
import javax.tv.xlet.XletContext;

public class ServiceContextFactoryImpl
extends ServiceContextFactory
implements ServiceContextListener {
    Vector contexts = new Vector();

    public ServiceContext createServiceContext() throws InsufficientResourcesException, SecurityException {
        ServiceContextPermission permission = new ServiceContextPermission("create", "own");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(permission);
        }
        if (this.contexts.size() >= Settings.ContextServiceLimit) {
            System.out.println("ServiceContext limit = " + this.contexts.size());
            throw new InsufficientResourcesException("number of contexts exceeds limits");
        }
        ServiceContextImpl serviceContext = null;
        try {
            serviceContext = new ServiceContextImpl();
            this.contexts.addElement(serviceContext);
            serviceContext.addListener(this);
        }
        catch (Exception e) {
            throw new InsufficientResourcesException(e.toString());
        }
        return serviceContext;
    }

    public ServiceContext[] getServiceContexts() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new ServiceContextPermission("access", "*"));
            }
            catch (SecurityException e) {
                try {
                    sm.checkPermission(new ServiceContextPermission("access", "own"));
                }
                catch (SecurityException se) {
                    return new ServiceContext[0];
                }
            }
        }
        int counter = 0;
        for (int i = 0; i < this.contexts.size(); ++i) {
            ServiceContextImpl context = (ServiceContextImpl)this.contexts.elementAt(i);
            if (context.isDestroyed()) continue;
            ++counter;
        }
        ServiceContext[] array = new ServiceContext[counter];
        counter = 0;
        for (int i = 0; i < this.contexts.size(); ++i) {
            ServiceContextImpl context = (ServiceContextImpl)this.contexts.elementAt(i);
            if (context.isDestroyed()) continue;
            array[counter] = context;
            ++counter;
        }
        return array;
    }

    public ServiceContext getServiceContext(XletContext ctx) throws ServiceContextException {
        ServiceContextImpl impl;
        ServiceContext sc;
        if (ctx == null) {
            throw new NullPointerException("XletContext null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServiceContextPermission("access", "own"));
        }
        if ((sc = (ServiceContext)ctx.getXletProperty("javax.tv.xlet.service_context")) == null) {
            throw new ServiceContextException("xlet not running in a ServiceContext");
        }
        if (sc instanceof ServiceContextImpl && (impl = (ServiceContextImpl)sc).isDestroyed()) {
            throw new ServiceContextException("ServiceContext is destroyed");
        }
        return sc;
    }

    public void receiveServiceContextEvent(ServiceContextEvent sce) {
        if (!(sce instanceof ServiceContextDestroyedEvent)) {
            return;
        }
        try {
            ServiceContext context = (ServiceContext)sce.getSource();
            if (context == null) {
                throw new NullPointerException("context == null");
            }
            for (int i = this.contexts.size() - 1; i >= 0; --i) {
                ServiceContext current = (ServiceContext)this.contexts.elementAt(i);
                if (current != context) continue;
                this.contexts.removeElementAt(i);
                break;
            }
        }
        catch (Exception e) {
            System.out.println("ReceiveServiceContextDestroyEvent implementation error.");
        }
    }
}

