/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import java.net.InetAddress;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.tv.locator.Locator;

public class LocatorImpl
implements Locator {
    public static final String ServiceProtocol = "service:/";
    public static final String ServiceComponentProtocol = "component:/";
    public static final String ServiceDescriptionProtocol = "description:/";
    public static final String ProgramEventProtocol = "event:/";
    public static final String ProgramEventDescriptionProtocol = "eventdescription:/";
    public static final String TransportStreamProtocol = "transport:/";
    public static final String NetworkProtocol = "network:/";
    public static final String BouquetProtocol = "bouquet:/";
    public static final String CarouselProtocol = "carousel:/";
    public static final String AlternateProtocol = "alternate:/";
    public static final String TransportProtocol = "transport:/";
    String externalForm = null;
    private static Hashtable mediaFiles = new Hashtable();
    private static Hashtable transforms = new Hashtable();

    public LocatorImpl(String locatorStr) {
        this.externalForm = locatorStr;
        if (!(locatorStr == null || locatorStr.toLowerCase().startsWith(ServiceProtocol) || locatorStr.toLowerCase().startsWith(ServiceDescriptionProtocol) || locatorStr.toLowerCase().startsWith(ServiceComponentProtocol) || locatorStr.toLowerCase().startsWith(ProgramEventProtocol) || locatorStr.toLowerCase().startsWith(ProgramEventDescriptionProtocol) || locatorStr.toLowerCase().startsWith("transport:/") || locatorStr.toLowerCase().startsWith(NetworkProtocol) || locatorStr.toLowerCase().startsWith(BouquetProtocol) || locatorStr.toLowerCase().startsWith(CarouselProtocol) || locatorStr.toLowerCase().startsWith("rtp:/") || locatorStr.toLowerCase().startsWith("http:/") || locatorStr.toLowerCase().startsWith("file:/"))) {
            this.externalForm = null;
        }
    }

    public String toExternalForm() {
        return this.externalForm;
    }

    public String toString() {
        return this.externalForm;
    }

    public boolean hasMultipleTransformations() {
        return transforms.get(this.toExternalForm()) != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Locator)) {
            return false;
        }
        return this.externalForm.equals(((Locator)o).toExternalForm());
    }

    public int hashCode() {
        return this.externalForm.hashCode();
    }

    public static Locator[] transformLocator(Locator source) {
        Locator[] locators = null;
        Vector list = (Vector)transforms.get(source.toExternalForm());
        if (list == null) {
            locators = new Locator[]{source};
        } else {
            locators = new Locator[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                locators[i] = (Locator)list.elementAt(i);
            }
        }
        return locators;
    }

    public static void setTransforms(Locator alias, Vector list) {
        if (list == null) {
            transforms.remove(alias.toExternalForm());
            return;
        }
        transforms.put(alias.toExternalForm(), list);
    }

    public static boolean equals(Locator locator1, Locator locator2) {
        if (!LocatorImpl.validLocator(locator1)) {
            return false;
        }
        if (!LocatorImpl.validLocator(locator2)) {
            return false;
        }
        return locator1.toExternalForm().equals(locator2.toExternalForm());
    }

    public static boolean validLocator(Locator locator) {
        LocatorImpl locatorImpl = new LocatorImpl(locator.toExternalForm());
        if (locatorImpl == null) {
            return false;
        }
        return locatorImpl.toExternalForm() != null;
    }

    public static boolean isSameProtocol(Locator locator1, Locator locator2) {
        String str1 = locator1.toExternalForm();
        String str2 = locator2.toExternalForm();
        int indx = str1.indexOf("/");
        return str2.startsWith(str1.substring(0, indx));
    }

    public static boolean isService(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(ServiceProtocol);
    }

    public static boolean isTIService(Locator locator) {
        return LocatorImpl.isService(locator) && locator.hasMultipleTransformations();
    }

    public static boolean isTDService(Locator locator) {
        return LocatorImpl.isService(locator) && !locator.hasMultipleTransformations();
    }

    public static boolean isServiceComponent(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(ServiceComponentProtocol);
    }

    public static boolean isServiceDescription(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(ServiceDescriptionProtocol);
    }

    public static boolean isProgramEvent(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(ProgramEventProtocol);
    }

    public static boolean isProgramEventDescription(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(ProgramEventDescriptionProtocol);
    }

    public static boolean isTransportStream(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith("transport:/");
    }

    public static boolean isNetwork(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(NetworkProtocol);
    }

    public static boolean isBouquet(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(BouquetProtocol);
    }

    public static boolean isAlternate(Locator locator) {
        if (locator == null) {
            return false;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return false;
        }
        return externalForm.startsWith(AlternateProtocol);
    }

    public static boolean isSelectable(Locator locator) {
        return LocatorImpl.isService(locator) || LocatorImpl.isProgramEvent(locator);
    }

    public static boolean isSIElement(Locator locator) {
        return LocatorImpl.isBouquet(locator) || LocatorImpl.isNetwork(locator) || LocatorImpl.isTDService(locator) || LocatorImpl.isProgramEvent(locator) || LocatorImpl.isServiceComponent(locator) || LocatorImpl.isTransportStream(locator);
    }

    public static String getServiceName(Locator locator) {
        if (locator == null) {
            return null;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return null;
        }
        if (LocatorImpl.isService(locator)) {
            return externalForm.substring(ServiceProtocol.length());
        }
        if (LocatorImpl.isServiceDescription(locator)) {
            return externalForm.substring(ServiceDescriptionProtocol.length());
        }
        if (LocatorImpl.isServiceComponent(locator)) {
            int i = externalForm.indexOf(ServiceProtocol);
            return externalForm.substring(i + ServiceProtocol.length());
        }
        if (LocatorImpl.isProgramEvent(locator)) {
            int i = externalForm.indexOf(ServiceProtocol);
            return externalForm.substring(i + ServiceProtocol.length());
        }
        return null;
    }

    public static String getProgramEventName(Locator locator) {
        if (locator == null) {
            return null;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return null;
        }
        if (LocatorImpl.isProgramEvent(locator)) {
            int i = externalForm.indexOf(ServiceProtocol);
            return externalForm.substring(ProgramEventProtocol.length(), i);
        }
        if (LocatorImpl.isProgramEventDescription(locator)) {
            return externalForm.substring(ProgramEventDescriptionProtocol.length());
        }
        return null;
    }

    public static String getServiceComponentName(Locator locator) {
        if (locator == null) {
            return null;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return null;
        }
        if (LocatorImpl.isServiceComponent(locator)) {
            int i = externalForm.indexOf(ServiceProtocol);
            return externalForm.substring(ServiceComponentProtocol.length(), i);
        }
        return null;
    }

    public static String getTransportStreamID(Locator locator) {
        if (locator == null) {
            return null;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return null;
        }
        if (!LocatorImpl.isTransportStream(locator)) {
            return null;
        }
        return externalForm.substring("transport:/".length());
    }

    public static String getBouquetName(Locator locator) {
        if (locator == null) {
            return null;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return null;
        }
        if (!LocatorImpl.isBouquet(locator)) {
            return null;
        }
        return externalForm.substring(BouquetProtocol.length());
    }

    public static String getNetworkName(Locator locator) {
        if (locator == null) {
            return null;
        }
        String externalForm = locator.toExternalForm();
        if (externalForm == null) {
            return null;
        }
        if (!LocatorImpl.isNetwork(locator)) {
            return null;
        }
        return externalForm.substring(NetworkProtocol.length());
    }

    public static Locator transformToService(Locator locator) {
        if (locator == null) {
            return null;
        }
        String serviceName = LocatorImpl.getServiceName(locator);
        if (serviceName != null) {
            return new LocatorImpl(ServiceProtocol + serviceName);
        }
        return null;
    }

    public static Locator transformToProgramEvent(Locator locator) {
        if (locator == null) {
            return null;
        }
        String serviceName = LocatorImpl.getServiceName(locator);
        String programName = LocatorImpl.getProgramEventName(locator);
        if (serviceName != null && programName != null) {
            return new LocatorImpl(ProgramEventProtocol + programName + ServiceProtocol + serviceName);
        }
        if (programName != null) {
            return new LocatorImpl(ProgramEventProtocol + programName);
        }
        return null;
    }

    public static Locator transformToServiceDescription(Locator locator) {
        if (locator == null) {
            return null;
        }
        String serviceName = LocatorImpl.getServiceName(locator);
        if (serviceName != null) {
            return new LocatorImpl(ServiceDescriptionProtocol + serviceName);
        }
        return null;
    }

    public static Locator transformToProgramEventDescription(Locator locator) {
        if (locator == null) {
            return null;
        }
        String programName = LocatorImpl.getProgramEventName(locator);
        if (programName != null) {
            return new LocatorImpl(ProgramEventDescriptionProtocol + programName);
        }
        return null;
    }

    public static Locator transformToTransportStream(Locator locator) {
        if (locator == null) {
            return null;
        }
        String name = LocatorImpl.getNetworkName(locator);
        if (name != null) {
            return new LocatorImpl("transport:/" + name);
        }
        return null;
    }

    public static Locator transformToAlternate(Locator locator) {
        if (locator == null) {
            return null;
        }
        if (LocatorImpl.isAlternate(locator)) {
            return locator;
        }
        if (LocatorImpl.isService(locator)) {
            return new LocatorImpl(AlternateProtocol + LocatorImpl.getServiceName(locator));
        }
        if (LocatorImpl.isProgramEvent(locator)) {
            String serviceName = LocatorImpl.getServiceName(locator);
            String programName = LocatorImpl.getProgramEventName(locator);
            return new LocatorImpl(AlternateProtocol + programName + ServiceProtocol + serviceName);
        }
        if (LocatorImpl.isServiceComponent(locator)) {
            return new LocatorImpl(ServiceComponentProtocol + LocatorImpl.getServiceComponentName(locator));
        }
        return null;
    }

    public static Locator createProgramEventLocator(String serviceName, String programName) {
        return new LocatorImpl(ProgramEventProtocol + programName + ServiceProtocol + serviceName);
    }

    public static void setMediaFile(String locatorStr, String urlStr) {
        mediaFiles.put(locatorStr, urlStr);
    }

    public static String getMediaFile(Locator locator) {
        return (String)mediaFiles.get(locator.toExternalForm());
    }

    public static String getMediaFile(String locatorStr) {
        return (String)mediaFiles.get(locatorStr);
    }

    public static InetAddress getLocalAddress(Locator locator) {
        if (locator == null) {
            return null;
        }
        if (!LocatorImpl.isServiceComponent(locator)) {
            return null;
        }
        URL url = null;
        String urlStr = LocatorImpl.getMediaFile(locator);
        try {
            url = new URL(urlStr);
            if (url == null) {
                return null;
            }
            System.out.println("InterfaceMapImpl ---------------");
            System.out.println("protocol: " + url.getProtocol());
            System.out.println("host: " + url.getHost());
            System.out.println("port: " + url.getPort());
            System.out.println("file: " + url.getFile());
        }
        catch (Exception e) {
            return null;
        }
        InetAddress address = null;
        address = url.getHost() == null || url.getHost().length() == 0 ? LocatorImpl.getHostAddress("localhost") : LocatorImpl.getHostAddress(url.getHost());
        return address;
    }

    private static synchronized InetAddress getHostAddress(String host) {
        if (host == null || host.equals("")) {
            return null;
        }
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

