/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tv;

import com.sun.tv.LocatorImpl;
import com.sun.tv.ServiceContextImpl;
import com.sun.tv.media.MediaSelectControlImpl;
import com.sun.tv.receiver.Settings;
import java.awt.Component;
import java.io.IOException;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerListener;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.tv.locator.Locator;
import javax.tv.service.selection.ServiceMediaHandler;

public class Handler
implements ServiceMediaHandler,
Player {
    private Locator locator = null;
    private Player player = null;
    private Control videoSizeControl = null;
    private Control mediaSelectControl = null;
    private ServiceContextImpl context = null;

    public Handler(Locator locator, ServiceContextImpl context) {
        this.locator = locator;
        this.context = context;
        String locatorStr = LocatorImpl.getMediaFile(locator);
        if (locatorStr == null) {
            System.out.println("Missing emulation for locator : " + locator.toExternalForm());
        }
        try {
            MediaLocator medialocator = new MediaLocator(locatorStr);
            this.player = Manager.createPlayer(medialocator);
        }
        catch (Exception e) {
            System.out.println("Handler error: " + locatorStr + ", " + e);
            this.player = null;
        }
        this.loadControls();
    }

    private void loadControls() {
        try {
            this.videoSizeControl = (Control)Class.forName(Settings.AWTVideoSizeControlClassName).newInstance();
            this.mediaSelectControl = new MediaSelectControlImpl(this, this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Locator getServiceLocator() {
        return this.locator;
    }

    public ServiceContextImpl getServiceContext() {
        return this.context;
    }

    public boolean validHandler() {
        return this.player != null;
    }

    public Locator[] getServiceContentLocators() {
        if (this.context == null) {
            return new Locator[0];
        }
        return this.context.getServiceComponentLocators();
    }

    public Component getVisualComponent() {
        if (this.player == null) {
            return null;
        }
        if (this.player.getState() < 300) {
            return null;
        }
        return this.player.getVisualComponent();
    }

    public GainControl getGainControl() {
        return this.player.getGainControl();
    }

    public Component getControlPanelComponent() {
        return this.player.getControlPanelComponent();
    }

    public void start() {
        this.player.start();
    }

    public void addController(Controller newController) throws IncompatibleTimeBaseException {
        this.player.addController(newController);
    }

    public void removeController(Controller oldController) {
        this.player.removeController(oldController);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        this.player.setSource(source);
    }

    public int getState() {
        return this.player.getState();
    }

    public int getTargetState() {
        return this.player.getTargetState();
    }

    public void realize() {
        this.player.realize();
    }

    public void prefetch() {
        this.player.prefetch();
    }

    public void deallocate() {
        this.player.deallocate();
    }

    public void close() {
        this.player.close();
    }

    public Time getStartLatency() {
        return this.player.getStartLatency();
    }

    public Control[] getControls() {
        Control[] playerControls = this.player.getControls();
        Control[] controls = null;
        if (playerControls != null) {
            controls = new Control[playerControls.length + 2];
            controls[0] = this.videoSizeControl;
            controls[1] = this.mediaSelectControl;
            for (int i = 0; i < playerControls.length; ++i) {
                controls[i + 2] = playerControls[i];
            }
        } else {
            controls = new Control[]{this.videoSizeControl, this.mediaSelectControl};
        }
        return controls;
    }

    public Control getControl(String forName) {
        if ("javax.tv.media.AWTVideoSizeControl".equals(forName)) {
            return this.videoSizeControl;
        }
        if ("javax.tv.media.MediaSelectControl".equals(forName)) {
            return this.mediaSelectControl;
        }
        return this.player.getControl(forName);
    }

    public void addControllerListener(ControllerListener listener) {
        this.player.addControllerListener(listener);
    }

    public void removeControllerListener(ControllerListener listener) {
        this.player.removeControllerListener(listener);
    }

    public Time getDuration() {
        return this.player.getDuration();
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        this.player.setTimeBase(master);
    }

    public void syncStart(Time at) {
        this.player.syncStart(at);
    }

    public void stop() {
        this.player.stop();
    }

    public void setStopTime(Time stopTime) {
        this.player.setStopTime(stopTime);
    }

    public Time getStopTime() {
        return this.player.getStopTime();
    }

    public void setMediaTime(Time now) {
        this.player.setMediaTime(now);
    }

    public Time getMediaTime() {
        return this.player.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.player.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return this.player.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.player.getTimeBase();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.player.mapToTimeBase(t);
    }

    public float getRate() {
        return this.player.getRate();
    }

    public float setRate(float factor) {
        return this.player.setRate(factor);
    }
}

