/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.amovie;

import com.sun.media.amovie.ActiveMovie;
import com.sun.media.amovie.EventThread;
import com.sun.tv.media.GainControlAdapter;
import com.sun.tv.media.MediaController;
import com.sun.tv.media.MediaTimeBase;
import com.sun.tv.media.SeekFailedEvent;
import com.sun.tv.media.content.video.mpeg.Handler;
import com.sun.tv.media.util.JMFSecurity;
import com.sun.tv.media.util.MediaThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.ConnectionErrorEvent;
import javax.media.Control;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.RateChangeEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class AMController
extends MediaController {
    final int MINVOLUME = -10000;
    ActiveMovie amovie = null;
    protected static final int TRYSET_DONE = 0;
    protected static final int TRYSET_CANT = 1;
    protected static final int TRYSET_PASTEOM = 2;
    private Integer closeLock = new Integer(0);
    private Integer sourceLock = new Integer(1);
    private boolean closed = false;
    private TimeBase amTimeBase = null;
    private int appletWindowHandle = 0;
    int pwidth = -1;
    int pheight = -1;
    int outWidth;
    int outHeight;
    private int width;
    private int height;
    boolean peerExists = false;
    private boolean muted = false;
    private boolean outputSizeSet = false;
    private EventThread eventThread = null;
    private boolean isFileStream = false;
    private boolean isRandomAccess = false;
    private boolean isSeekable = false;
    private boolean hasAudio = false;
    private boolean hasVideo = false;
    private boolean deallocated = false;
    private boolean sourceIsOn = false;
    private DataSource source = null;
    private PullSourceStream stream = null;
    private SourceStream originalStream = null;
    private String mpegFile = null;
    private Handler player;
    private Component visualComponent = null;
    private boolean seekFailed = false;
    private Time timeWhenMediaStopped = null;
    private boolean mediaTimeChanged = false;
    private Time requestedMediaTime = new Time(0L);
    private Time lastMediaTime = new Time(0L);
    private String id = "JavaActiveMovie_" + this.hashCode();
    private int contentLength = -1;
    private boolean doneDownloading = false;
    private boolean blockedOnRead = false;
    private Thread blockThread = null;
    private boolean abortingRealize = false;
    private boolean setRatePending = false;
    private float setRateValue = 1.0f;
    private GainControl gc = null;
    private Control[] controls = null;
    private static boolean libraryLoaded = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    protected Time eomDuration = Duration.DURATION_UNKNOWN;
    static /* synthetic */ Class class$com$sun$media$amovie$AMController;

    public AMController(Handler handler) {
        String library = "jmam";
        if (!libraryLoaded) {
            try {
                JMFSecurity.loadLibrary(library);
                libraryLoaded = true;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to load native MPEG library");
            }
        }
        this.player = handler;
    }

    public void setSource(DataSource s) throws IncompatibleSourceException {
        if (!(s instanceof PullDataSource)) {
            throw new IncompatibleSourceException("MPEG Controller requires a PullDataSource");
        }
        this.source = s;
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        super.setTimeBase(tb);
    }

    public TimeBase getTimeBase() {
        if (this.amTimeBase == null) {
            this.amTimeBase = new AMTimeBase(this);
        }
        return this.amTimeBase;
    }

    public boolean isConfigurable() {
        return false;
    }

    private void updateControls(ActiveMovie amovie) {
    }

    public Control[] getControls() {
        int n = 0;
        if (this.hasAudio) {
            ++n;
        }
        this.controls = new Control[n];
        n = 0;
        if (this.hasAudio) {
            if (this.gc == null) {
                this.gc = new GCA();
            }
            this.controls[n++] = this.gc;
        }
        return this.controls;
    }

    private ActiveMovie createActiveMovie(DataSource s) {
        URL url = null;
        MediaLocator ml = s.getLocator();
        if (ml != null) {
            try {
                url = ml.getURL();
            }
            catch (MalformedURLException e) {
                ml = null;
            }
        }
        if (ml != null && ml.getProtocol().equals("file")) {
            int indexPipe;
            this.mpegFile = url.getFile();
            if (this.mpegFile.startsWith("/")) {
                this.mpegFile = this.mpegFile.substring(1);
            }
            while ((indexPipe = this.mpegFile.indexOf("|")) >= 0) {
                if (indexPipe > 0) {
                    this.mpegFile = this.mpegFile.substring(0, indexPipe) + ":" + this.mpegFile.substring(indexPipe + 1);
                    continue;
                }
                this.mpegFile = this.mpegFile.substring(1);
            }
            this.isFileStream = true;
            this.isRandomAccess = true;
            this.isSeekable = true;
            ActiveMovie am = new ActiveMovie(this, this.mpegFile);
            this.hasVideo = am.hasVideo();
            this.hasAudio = am.hasAudio();
            this.updateControls(am);
            return am;
        }
        if (s instanceof PullDataSource) {
            PullSourceStream[] streams = ((PullDataSource)s).getStreams();
            if (streams != null && streams.length > 0) {
                this.stream = streams[0];
                this.originalStream = this.stream;
                if (this.stream instanceof Seekable) {
                    this.isSeekable = true;
                    if (((Seekable)((Object)this.stream)).isRandomAccess()) {
                        this.isRandomAccess = true;
                    }
                    if (ml != null && ml.getProtocol().startsWith("http") && url != null) {
                        this.isRandomAccess = false;
                    }
                }
                ActiveMovie am = new ActiveMovie(this, this.stream, this.isRandomAccess, (int)this.originalStream.getContentLength());
                this.hasVideo = am.hasVideo();
                this.hasAudio = am.hasAudio();
                this.updateControls(am);
                return am;
            }
        } else {
            System.err.println("Mpeg Player can only handle pull data sources.");
        }
        return null;
    }

    public int canRead(int bytes) {
        return bytes;
    }

    public long canSeek(long seekTo) {
        return seekTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long seek(long seekTo) {
        if (this.abortingRealize) {
            System.out.println("seek.0");
            return 0L;
        }
        Integer n = this.sourceLock;
        synchronized (n) {
            if (this.stream instanceof Seekable && this.sourceIsOn) {
                if (((Seekable)((Object)this.stream)).tell() == seekTo) {
                    return seekTo;
                }
                if (((Seekable)((Object)this.stream)).isRandomAccess()) {
                    long seeked = ((Seekable)((Object)this.stream)).seek(seekTo);
                    return seeked;
                }
                if (seekTo == 0L) {
                    return ((Seekable)((Object)this.stream)).seek(seekTo);
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] data, int offset, int length) {
        if (this.abortingRealize) {
            return -1;
        }
        Integer n = this.sourceLock;
        synchronized (n) {
            if (this.stream != null && this.sourceIsOn) {
                try {
                    int readBytes = this.stream.read(data, offset, length);
                    return readBytes;
                }
                catch (IOException ioe) {
                    this.sendEvent(new ConnectionErrorEvent(this, ioe.getMessage()));
                    return -1;
                }
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRealize() {
        this.abortingRealize = false;
        if (this.amovie != null) {
            this.amTimeBase = null;
            this.amovie.kill();
            this.amovie.dispose();
            this.amovie = null;
        }
        this.startSource(true, true);
        Integer n = this.closeLock;
        synchronized (n) {
            this.amovie = this.createActiveMovie(this.source);
            if (this.amovie == null) {
                return false;
            }
            if (!this.amovie.isRealized()) {
                this.amovie = null;
                return false;
            }
            if (this.abortingRealize) {
                this.doDeallocate();
                this.amovie.dispose();
                this.amovie = null;
                return false;
            }
        }
        this.amovie.amStopWhenReady();
        this.amovie.doneRealize();
        if (this.amTimeBase == null) {
            this.amTimeBase = new AMTimeBase(this);
        }
        this.setMediaLength((long)(this.amovie.getDuration() * 1.0E9));
        this.amovie.setVisible(0);
        this.startSource(false, false);
        return true;
    }

    protected void abortRealize() {
        this.abortingRealize = true;
        this.startSource(false, true);
    }

    protected void abortPrefetch() {
        this.startSource(false, true);
    }

    protected boolean doPrefetch() {
        if (this.amovie == null && !this.doRealize()) {
            return false;
        }
        if (this.amovie != null && this.visualComponent != null && this.peerExists) {
            this.setOwner(this.visualComponent);
        }
        return true;
    }

    protected final void doStart() {
        System.out.println("doStart() = " + this.getState());
        if (this.amovie == null) {
            this.doPrefetch();
        }
        this.startSource(true, false);
        this.amovie.restart();
        if (this.setRatePending) {
            this.amovie.setRate(this.setRateValue);
            this.setRatePending = false;
            if ((float)this.amovie.getRate() != this.setRateValue) {
                this.sendEvent(new RateChangeEvent(this, (float)this.amovie.getRate()));
            }
        }
        if (this.mediaTimeChanged) {
            int returnVal = this.trySetMediaTime(this.requestedMediaTime);
            if (returnVal == 1) {
                super.stop();
                this.sendEvent(new SeekFailedEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                return;
            }
            if (returnVal == 2) {
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                return;
            }
        }
        this.mediaTimeChanged = false;
        GainControl gc = this.player.getGainControl();
        if (gc != null) {
            this.amovie.setVolume((int)(gc.getDB() * 100.0f));
        }
        this.amovie.amRun();
        if (!this.peerExists) {
            this.amovie.setVisible(0);
        }
        if (gc != null) {
            this.muteChange(gc.getMute());
        }
        if (this.eventThread == null) {
            this.eventThread = new EventThread();
            this.eventThread.setController(this);
            this.eventThread.start();
        }
        this.eventThread.restart();
    }

    public void doStop() {
        System.err.println("In doStop()" + this.eventThread);
        super.doStop();
        this.lastMediaTime = this.getMediaTime();
        if (this.amovie != null) {
            this.amovie.amPause();
            this.amovie.pause();
        }
        if (this.eventThread != null) {
            this.eventThread.pause();
        }
        this.startSource(false, false);
        this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
    }

    protected synchronized void doDeallocate() {
        this.startSource(false, false);
        this.timeWhenMediaStopped = this.getMediaTime();
        this.mediaTimeChanged = true;
        this.requestedMediaTime = new Time(0L);
        this.lastMediaTime = this.timeWhenMediaStopped;
        if (this.amovie != null) {
            this.blockedOnRead = false;
            if (this.amovie.getVolume() == -10000) {
                this.amovie.setVolume(-5000);
            }
            this.amovie.kill();
            if (this.eventThread != null) {
                this.eventThread.kill();
                this.eventThread = null;
            }
        }
    }

    public void finalize() {
        if (this.amovie != null) {
            this.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        if (this.getState() == 200) {
            this.abortRealize();
        }
        Integer n = this.closeLock;
        synchronized (n) {
            if (this.closed) {
                return;
            }
            this.doDeallocate();
            if (this.amovie != null) {
                this.amovie.dispose();
                this.amTimeBase = null;
                this.amovie = null;
            }
            if (this.source != null) {
                this.source.disconnect();
            }
            this.source = null;
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaTime(Time time) {
        super.setMediaTime(time);
        AMController aMController = this;
        synchronized (aMController) {
            this.requestedMediaTime = time;
            this.mediaTimeChanged = true;
        }
        if (this.stream == null) {
            this.amovie.restart();
            if (this.trySetMediaTime(time) == 0) {
                this.mediaTimeChanged = false;
            }
        }
    }

    protected int trySetMediaTime(Time time) {
        if (this.amovie != null) {
            long duration = this.getDuration().getNanoseconds();
            long now = time.getNanoseconds();
            if (this.getDuration() == Duration.DURATION_UNKNOWN && now != 0L) {
                return 1;
            }
            if (now < 0L) {
                return 1;
            }
            if (now > duration) {
                return 2;
            }
            if (!this.isSeekable) {
                return 1;
            }
            double nowSeconds = (double)now * 1.0E-9;
            if (this.isRandomAccess) {
                this.amovie.setCurrentPosition(nowSeconds);
                return 0;
            }
            if (this.stream != null) {
                if (now != 0L) {
                    return 1;
                }
                ((Seekable)((Object)this.stream)).seek(0L);
                this.amovie.setCurrentPosition(0.0);
                return 0;
            }
        }
        return 1;
    }

    public float doSetRate(float factor) {
        if (this.amovie == null) {
            return 1.0f;
        }
        if ((double)factor < 0.1) {
            factor = 0.1f;
        }
        if ((double)factor > 10.0) {
            factor = 10.0f;
        }
        if ((float)this.amovie.getRate() != factor) {
            this.setRatePending = true;
            this.setRateValue = factor;
        }
        return factor;
    }

    Component createVisualComponent() {
        Component c = null;
        Class<?> visclass = null;
        if (visclass == null) {
            try {
                visclass = Class.forName("com.sun.media.amovie.VisualComponent");
            }
            catch (Throwable th) {
                return null;
            }
            System.out.println("VisualClass = " + visclass);
        }
        Class[] params = new Class[]{class$com$sun$media$amovie$AMController == null ? (class$com$sun$media$amovie$AMController = AMController.class$("com.sun.media.amovie.AMController")) : class$com$sun$media$amovie$AMController};
        Constructor<?> cons = null;
        try {
            cons = visclass.getConstructor(params);
            Object[] amparam = new AMController[]{this};
            c = (Component)cons.newInstance(amparam);
            return c;
        }
        catch (Throwable tr) {
            return null;
        }
    }

    public Component getVisualComponent() {
        if (this.amovie == null) {
            return null;
        }
        if (this.visualComponent == null) {
            if (this.amovie.getVideoWidth() == 0 || this.amovie.getVideoHeight() == 0) {
                this.visualComponent = null;
            } else {
                this.visualComponent = this.createVisualComponent();
                this.visualComponent.addComponentListener(new ComponentAdapter(){
                    private int lastWidth = -1;
                    private int lastHeight = -1;

                    public void componentResized(ComponentEvent ce) {
                        if (AMController.this.amovie != null) {
                            Dimension csize = ce.getComponent().getSize();
                            if (csize.width == this.lastWidth && csize.height == this.lastHeight) {
                                return;
                            }
                            this.lastWidth = csize.width;
                            this.lastHeight = csize.height;
                            AMController.this.outputSizeSet = true;
                            AMController.this.zoom(this.lastWidth, this.lastHeight);
                        }
                    }
                });
            }
        }
        return this.visualComponent;
    }

    public Time getDuration() {
        if (this.eomDuration != Duration.DURATION_UNKNOWN) {
            return this.eomDuration;
        }
        if (this.amovie == null) {
            return Duration.DURATION_UNKNOWN;
        }
        double amduration = this.amovie.getDuration();
        if (this.isRandomAccess) {
            return new Time((long)(amduration * 1.0E9));
        }
        return Duration.DURATION_UNKNOWN;
    }

    void setOwner(Component parent) {
        if (this.amovie != null && parent != null) {
            this.amovie.setVisible(1);
            parent.getPreferredSize();
            this.amovie.setWindowPosition(0, 0, this.outWidth, this.outHeight);
        }
    }

    void sendEOM() {
        if (this.amovie != null) {
            this.amovie.amPause();
            this.amovie.pause();
        }
        super.stop();
        Time earlier = this.eomDuration;
        this.eomDuration = new Time(this.getMediaTime().getNanoseconds());
        this.startSource(false, false);
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        if (earlier == Duration.DURATION_UNKNOWN) {
            this.sendEvent(new DurationUpdateEvent(this, this.eomDuration));
        }
        System.out.println("stream = " + this.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSource(boolean on, boolean regardless) {
        if (this.sourceIsOn == on) {
            return true;
        }
        Integer n = this.sourceLock;
        synchronized (n) {
            if (regardless) {
                try {
                    if (on) {
                        this.source.start();
                        if (this.amovie != null) {
                            this.amovie.stopDataFlow(false);
                        }
                    } else {
                        if (this.amovie != null) {
                            this.amovie.stopDataFlow(true);
                        }
                        this.source.stop();
                    }
                }
                catch (Exception ge) {
                    return false;
                }
                this.sourceIsOn = on;
            }
            return true;
        }
    }

    private void zoomChanged() {
        if (this.amovie == null) {
            return;
        }
        int width = this.amovie.getVideoWidth();
        int height = this.amovie.getVideoHeight();
        if (this.peerExists) {
            this.amovie.setWindowPosition(0, 0, this.outWidth, this.outHeight);
        }
        if (this.pwidth != width || this.pheight != height) {
            this.pwidth = width;
            this.pheight = height;
        }
    }

    private void zoom(int width, int height) {
        this.outWidth = width;
        if (this.outWidth < 120) {
            this.outWidth = 120;
        }
        this.outHeight = height;
        if (this.outHeight < 1) {
            this.outHeight = 1;
        }
        this.zoomChanged();
    }

    public boolean audioEnabled() {
        if (this.amovie != null) {
            return this.amovie.hasAudio();
        }
        return true;
    }

    public boolean videoEnabled() {
        if (this.amovie != null) {
            return this.amovie.hasVideo();
        }
        return true;
    }

    public void gainChange(float g) {
        if (this.amovie != null && !this.muted && this.gc != null) {
            float dB = this.gc.getDB();
            if (dB > 0.0f) {
                dB = 0.0f;
            }
            if (dB < -70.0f) {
                dB = -100.0f;
            }
            this.amovie.setVolume((int)(dB * 100.0f));
        }
    }

    public void muteChange(boolean state) {
        if (this.amovie != null) {
            if (state) {
                this.muted = true;
                this.amovie.setVolume(-10000);
            } else {
                this.muted = false;
                try {
                    float dB = this.gc.getDB();
                    if (dB > 0.0f) {
                        dB = 0.0f;
                    }
                    if (dB < -70.0f) {
                        dB = -100.0f;
                    }
                    this.amovie.setVolume((int)(dB * 100.0f));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ProgressThread
    extends MediaThread {
        private Handler mp;

        ProgressThread(Handler player) {
            this.mp = player;
            this.setName("JMF AMController Progress Thread: " + this.getName());
        }

        public void start() {
            if (!this.isAlive()) {
                super.start();
            }
        }

        public void tryStop() {
        }

        public void run() {
        }
    }

    class GCA
    extends GainControlAdapter {
        GCA() {
            super(false);
            this.setDB(1.0f);
        }

        public void setMute(boolean mute) {
            super.setMute(mute);
            AMController.this.muteChange(mute);
        }

        public float setLevel(float g) {
            float level = super.setLevel(g);
            AMController.this.gainChange(g);
            return level;
        }
    }

    class AMTimeBase
    extends MediaTimeBase {
        private AMController controller;

        public AMTimeBase(AMController controller) {
            this.controller = controller;
        }

        public long getNanoseconds() {
            return this.getMediaTime();
        }

        public long getMediaTime() {
            long time = 0L;
            if (this.controller.amovie != null) {
                time = this.controller.amovie.getTime() * 1000L;
            }
            return time;
        }
    }
}

