package org.havi.ui.event;

/*
 * Copyright 2000-2003 by HAVi, Inc. Java is a trademark of Sun
 * Microsystems, Inc. All rights reserved.  
 */

import java.util.EventListener;

/**
   The {@link org.havi.ui.event.HTextListener
   HTextListener} interface enables the reception of {@link
   org.havi.ui.event.HTextEvent HTextEvents}, as generated
   by objects implementing {@link org.havi.ui.HTextValue
   HTextValue}.
    
  <hr>
  The parameters to the constructors are as follows, in cases where
  parameters are not used, then the constructor should use the default
  values.
  <p>
  <h3>Default parameter values exposed in the constructors</h3>
  <table border>
  <tr><th>Parameter</th><th>Description</th><th>Default value</th> 
  <th>Set method</th><th>Get method</th></tr>
  <tr><td colspan=5>None.</td></tr>
  </table>
  <h3>Default parameter values not exposed in the constructors</h3>
  <table border>
  <tr><th>Description</th><th>Default value</th><th>Set method</th>
  <th>Get method</th></tr>
  <tr><td colspan=4>None.</td></tr>
  </table>
   
*/

public interface HTextListener 
    extends java.util.EventListener
{
    /**
     * Called when the textual content of
     * an {@link org.havi.ui.HTextValue HTextValue} component has changed.
     * 
     * @param e is the {@link org.havi.ui.event.HTextEvent
     * HTextEvent} generated by the object implementing {@link
     * org.havi.ui.HTextValue HTextValue}.
     */
    public abstract void textChanged(org.havi.ui.event.HTextEvent e);

    /**
     * Called when the caret position of
     * an {@link org.havi.ui.HTextValue HTextValue} component has moved.
     * 
     * @param e is the {@link org.havi.ui.event.HTextEvent
     * HTextEvent} generated by the object implementing {@link
     * org.havi.ui.HTextValue HTextValue}.
     */
    public abstract void caretMoved(org.havi.ui.event.HTextEvent e);

}

