package org.havi.ui.event;

/*
 * Copyright 2000-2003 by HAVi, Inc. Java is a trademark of Sun
 * Microsystems, Inc. All rights reserved.  
 */

import java.util.EventObject;
                        
/**
   This event is generated by the system when a component is moved
   on-screen, rather than within a container.
   
  <hr>
  The parameters to the constructors are as follows, in cases where
  parameters are not used, then the constructor should use the default
  values.
  <p>
  <h3>Default parameter values exposed in the constructors</h3>
  <table border>
  <tr><th>Parameter</th><th>Description</th><th>Default value</th> 
  <th>Set method</th><th>Get method</th></tr>
  <tr><td colspan=5>None.</td></tr>
  </table>
  <h3>Default parameter values not exposed in the constructors</h3>
  <table border>
  <tr><th>Description</th><th>Default value</th><th>Set method</th>
  <th>Get method</th></tr>
  <tr><td colspan=4>None.</td></tr>
  </table>
   
*/

public class HScreenLocationModifiedEvent 
    extends java.util.EventObject
{
    /**
     * Creates an {@link org.havi.ui.event.HScreenLocationModifiedEvent
     * HScreenLocationModifiedEvent} object.  See the class description for
     * details of constructor parameters and default values.  
     *
     * @param source the Component whose on-screen location has been
     * modified.  
     */
    public HScreenLocationModifiedEvent(Object source)
    {
	super(source);
    }

    /**
     * Returns the Component whose on-screen location has been
     * modified.
     *
     * @return the Component whose on-screen location has been
     * modified.  
     */
    public Object getSource()
    {
	return (null);
    }

}

